/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners.compat;

import dev.shadowsoffire.apothic_spawners.ApothicSpawners;
import dev.shadowsoffire.apothic_spawners.block.ApothSpawnerBlock;
import dev.shadowsoffire.apothic_spawners.block.ApothSpawnerTile;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStats;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class SpawnerHwylaPlugin
implements IWailaPlugin,
IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void register(IWailaCommonRegistration reg) {
        reg.registerBlockDataProvider((IServerDataProvider)this, ApothSpawnerTile.class);
    }

    public void registerClient(IWailaClientRegistration reg) {
        reg.registerBlockComponent((IComponentProvider)this, ApothSpawnerBlock.class);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (Screen.hasControlDown()) {
            ApothSpawnerTile tile = new ApothSpawnerTile(BlockPos.ZERO, Blocks.SPAWNER.defaultBlockState());
            tile.loadAdditional(accessor.getServerData(), (HolderLookup.Provider)accessor.getLevel().registryAccess());
            SpawnerStats.generateTooltip(tile, arg_0 -> ((ITooltip)tooltip).add(arg_0));
        } else {
            tooltip.add((Component)ApothicSpawners.lang("misc", "ctrl_stats", new Object[0]));
        }
    }

    public void appendServerData(CompoundTag tag, BlockAccessor access) {
        BlockEntity blockEntity = access.getBlockEntity();
        if (blockEntity instanceof ApothSpawnerTile) {
            ApothSpawnerTile spw = (ApothSpawnerTile)blockEntity;
            spw.saveAdditional(tag, (HolderLookup.Provider)access.getLevel().registryAccess());
        }
    }

    public ResourceLocation getUid() {
        return ApothicSpawners.loc("spawner");
    }
}

