/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.EntityDreadLichSkull;
import com.iafenvoy.iceandfire.render.model.ModelDreadLichSkull;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class RenderDreadLichSkull
extends EntityRenderer<EntityDreadLichSkull> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/dread/dread_lich_skull.png");
    private static final ModelDreadLichSkull MODEL_SPIRIT = new ModelDreadLichSkull();

    public RenderDreadLichSkull(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EntityDreadLichSkull entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (entity.tickCount > 3) {
            matrixStackIn.pushPose();
            matrixStackIn.scale(1.5f, -1.5f, 1.5f);
            float yaw = entity.yRotO + (entity.getYRot() - entity.yRotO) * partialTicks;
            matrixStackIn.translate(0.0f, 0.0f, 0.0f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(yaw - 180.0f));
            VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.eyes((ResourceLocation)TEXTURE), (boolean)false, (boolean)false);
            MODEL_SPIRIT.renderToBuffer(matrixStackIn, ivertexbuilder, 240, OverlayTexture.NO_OVERLAY, -1);
            matrixStackIn.popPose();
        }
        super.render((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTexture(EntityDreadLichSkull entity) {
        return TEXTURE;
    }
}

