/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.tool;

import com.iafenvoy.iceandfire.entity.EntityTideTrident;
import com.iafenvoy.uranus.object.RegistryHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ItemTideTrident
extends TridentItem {
    public ItemTideTrident() {
        super(new Item.Properties().durability(400));
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity user, int timeLeft) {
        if (user instanceof Player) {
            int riptideLevel;
            Player player = (Player)user;
            int time = this.getUseDuration(stack, user) - timeLeft;
            if (time >= 10 && ((riptideLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)RegistryHelper.getEnchantment((RegistryAccess)worldIn.registryAccess(), (ResourceKey)Enchantments.RIPTIDE), (ItemStack)stack)) <= 0 || player.isInWaterOrRain())) {
                if (!worldIn.isClientSide) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
                    if (riptideLevel == 0) {
                        EntityTideTrident tideTrident = new EntityTideTrident(worldIn, (LivingEntity)player, stack);
                        tideTrident.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f + (float)riptideLevel * 0.5f, 1.0f);
                        if (player.getAbilities().instabuild) {
                            tideTrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        worldIn.addFreshEntity((Entity)tideTrident);
                        worldIn.playSound(null, (Entity)tideTrident, (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.getAbilities().instabuild) {
                            player.getInventory().removeItem(stack);
                        }
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (riptideLevel > 0) {
                    float yaw = player.getYRot();
                    float pitch = player.getXRot();
                    float velocityX = -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
                    float velocityY = -Mth.sin((float)(pitch * ((float)Math.PI / 180)));
                    float velocityZ = Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
                    float speed = Mth.sqrt((float)(velocityX * velocityX + velocityY * velocityY + velocityZ * velocityZ));
                    float targetSpeed = 3.0f * ((1.0f + (float)riptideLevel) / 4.0f);
                    player.push((double)(velocityX *= targetSpeed / speed), (double)(velocityY *= targetSpeed / speed), (double)(velocityZ *= targetSpeed / speed));
                    player.startAutoSpinAttack(20, 8.0f, stack);
                    if (player.onGround()) {
                        player.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    Holder sound = riptideLevel >= 3 ? SoundEvents.TRIDENT_RIPTIDE_3 : (riptideLevel == 2 ? SoundEvents.TRIDENT_RIPTIDE_2 : SoundEvents.TRIDENT_RIPTIDE_1);
                    worldIn.playSound(null, (Entity)player, (SoundEvent)sound.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.legendary_weapon.desc").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.tide_trident.desc_0").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.tide_trident.desc_1").withStyle(ChatFormatting.GRAY));
    }
}

