/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.entity.EntityGhost;
import com.iafenvoy.iceandfire.registry.IafEntities;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;

public class BlockGraveyardSoil
extends Block {
    public BlockGraveyardSoil() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).sound(SoundType.GRAVEL).strength(5.0f, 1.0f).randomTicks());
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isClientSide) {
            if (!worldIn.hasChunksAt(pos.offset(-3, -3, -3), pos.offset(3, 3, 3))) {
                return;
            }
            if (!worldIn.isDay() && !worldIn.getBlockState(pos.above()).canOcclude() && rand.nextInt(9) == 0 && worldIn.getDifficulty() != Difficulty.PEACEFUL) {
                int checkRange = 32;
                int k = worldIn.getEntitiesOfClass(EntityGhost.class, new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)).inflate((double)checkRange)).size();
                if (k < 10) {
                    EntityGhost ghost = (EntityGhost)((EntityType)IafEntities.GHOST.get()).create((Level)worldIn);
                    assert (ghost != null);
                    ghost.absMoveTo((float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f, ThreadLocalRandom.current().nextFloat() * 360.0f, 0.0f);
                    ghost.finalizeSpawn((ServerLevelAccessor)worldIn, worldIn.getCurrentDifficultyAt(pos), MobSpawnType.SPAWNER, null);
                    worldIn.addFreshEntity((Entity)ghost);
                    ghost.setAnimation(EntityGhost.ANIMATION_SCARE);
                    ghost.restrictTo(pos, 16);
                }
            }
        }
    }
}

