/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafSounds;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemSirenFlute
extends Item {
    public ItemSirenFlute() {
        super(new Item.Properties().durability(200));
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand hand) {
        ItemStack itemStackIn = player.getItemInHand(hand);
        player.startUsingItem(hand);
        player.getCooldowns().addCooldown((Item)this, 900);
        double dist = 32.0;
        Vec3 Vector3d = player.getEyePosition(1.0f);
        Vec3 Vector3d1 = player.getViewVector(1.0f);
        Vec3 Vector3d2 = Vector3d.add(Vector3d1.x * dist, Vector3d1.y * dist, Vector3d1.z * dist);
        Entity pointedEntity = null;
        List list = player.level().getEntities((Entity)player, player.getBoundingBox().expandTowards(Vector3d1.x * dist, Vector3d1.y * dist, Vector3d1.z * dist).inflate(1.0, 1.0, 1.0), entity -> {
            LivingEntity living;
            IBlacklistedFromStatues blacklisted;
            LivingEntity living2;
            boolean blindness = entity instanceof LivingEntity && (living2 = (LivingEntity)entity).hasEffect(MobEffects.BLINDNESS) || entity instanceof IBlacklistedFromStatues && !(blacklisted = (IBlacklistedFromStatues)entity).canBeTurnedToStone();
            return entity != null && entity.isPickable() && !blindness && (entity instanceof Player || entity instanceof LivingEntity && DragonUtils.isAlive(living = (LivingEntity)entity));
        });
        double d2 = dist;
        for (Entity entity1 : list) {
            double d3;
            AABB axisalignedbb = entity1.getBoundingBox().inflate((double)entity1.getPickRadius());
            Optional raytraceresult = axisalignedbb.clip(Vector3d, Vector3d2);
            if (axisalignedbb.contains(Vector3d)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                d2 = 0.0;
                continue;
            }
            if (!raytraceresult.isPresent() || !((d3 = Vector3d.distanceTo((Vec3)raytraceresult.get())) < d2) && d2 != 0.0) continue;
            if (entity1.getRootVehicle() == player.getRootVehicle()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                continue;
            }
            pointedEntity = entity1;
            d2 = d3;
        }
        if (pointedEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pointedEntity;
            IafEntityData data = IafEntityData.get(livingEntity);
            data.miscData.setLoveTicks(200);
            itemStackIn.hurtAndBreak(2, (LivingEntity)player, EquipmentSlot.MAINHAND);
            player.getCooldowns().addCooldown(itemStackIn.getItem(), 900);
        }
        player.playSound((SoundEvent)IafSounds.SIREN_SONG.get(), 1.0f, 1.0f);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStackIn);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.legendary_weapon.desc").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.siren_flute.desc_0").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.siren_flute.desc_1").withStyle(ChatFormatting.GRAY));
    }
}

