/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityHippogryph;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;

public class HippogryphAITarget<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    private final EntityHippogryph hippogryph;

    public HippogryphAITarget(EntityHippogryph entityIn, Class<T> classTarget, boolean checkSight, Predicate<LivingEntity> targetPredicate) {
        super((Mob)entityIn, classTarget, 20, checkSight, false, targetPredicate);
        this.hippogryph = entityIn;
    }

    public HippogryphAITarget(EntityHippogryph entityIn, Class<T> classTarget, int i, boolean checkSight, Predicate<LivingEntity> targetPredicate) {
        super((Mob)entityIn, classTarget, i, checkSight, false, targetPredicate);
        this.hippogryph = entityIn;
    }

    public boolean canUse() {
        if (super.canUse() && this.target != null && !this.target.getClass().equals(this.hippogryph.getClass()) && this.hippogryph.getBbWidth() >= this.target.getBbWidth()) {
            if (this.target instanceof Player) {
                return !this.hippogryph.isTame();
            }
            if (!this.hippogryph.isOwnedBy(this.target) && this.hippogryph.canMove() && this.target instanceof Animal) {
                if (this.hippogryph.isTame()) {
                    return DragonUtils.canTameDragonAttack(this.hippogryph, (Entity)this.target);
                }
                return true;
            }
        }
        return false;
    }
}

