/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityCockatrice;
import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class CockatriceAIWander
extends Goal {
    private final EntityCockatrice cockatrice;
    private final double speed;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private int executionChance;
    private boolean mustUpdate;

    public CockatriceAIWander(EntityCockatrice creatureIn, double speedIn) {
        this(creatureIn, speedIn, 20);
    }

    public CockatriceAIWander(EntityCockatrice creatureIn, double speedIn, int chance) {
        this.cockatrice = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.cockatrice.canMove()) {
            return false;
        }
        if (this.cockatrice.getCommand() != 3 && this.cockatrice.getCommand() != 0) {
            return false;
        }
        if (!this.mustUpdate && this.cockatrice.getRandom().nextInt(this.executionChance) != 0) {
            return false;
        }
        Vec3 Vector3d = DefaultRandomPos.getPos((PathfinderMob)this.cockatrice, (int)10, (int)7);
        if (Vector3d == null) {
            return false;
        }
        this.xPosition = Vector3d.x;
        this.yPosition = Vector3d.y;
        this.zPosition = Vector3d.z;
        this.mustUpdate = false;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.cockatrice.getNavigation().isDone();
    }

    public void start() {
        this.cockatrice.getNavigation().moveTo(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int newchance) {
        this.executionChance = newchance;
    }
}

