/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntitySiren;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AquaticAIGetOutOfWater
extends Goal {
    private final Mob creature;
    private final double movementSpeed;
    private final Level world;
    private double shelterX;
    private double shelterY;
    private double shelterZ;

    public AquaticAIGetOutOfWater(Mob theCreatureIn, double movementSpeedIn) {
        this.creature = theCreatureIn;
        this.movementSpeed = movementSpeedIn;
        this.world = theCreatureIn.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.creature.isInWater() || !((EntitySiren)this.creature).wantsToSing()) {
            return false;
        }
        Vec3 Vector3d = this.findPossibleShelter();
        if (Vector3d == null) {
            return false;
        }
        this.shelterX = Vector3d.x;
        this.shelterY = Vector3d.y;
        this.shelterZ = Vector3d.z;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.creature.getNavigation().isDone();
    }

    public void start() {
        this.creature.getNavigation().moveTo(this.shelterX, this.shelterY, this.shelterZ, this.movementSpeed);
    }

    private Vec3 findPossibleShelter() {
        RandomSource random = this.creature.getRandom();
        BlockPos blockpos = BlockPos.containing((double)this.creature.getBlockX(), (double)this.creature.getBoundingBox().minY, (double)this.creature.getBlockZ());
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.offset(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (!this.world.getBlockState(blockpos1).isSolidRender((BlockGetter)this.world, blockpos1)) continue;
            return new Vec3((double)blockpos1.getX(), (double)blockpos1.getY(), (double)blockpos1.getZ());
        }
        return null;
    }
}

