/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.entity.EntityPixie;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityPixieCharge
extends Fireball {
    private final float[] rgb;
    public int ticksInAir;

    public EntityPixieCharge(EntityType<? extends Fireball> t, Level worldIn) {
        super(t, worldIn);
        this.rgb = EntityPixie.PARTICLE_RGB[this.random.nextInt(EntityPixie.PARTICLE_RGB.length - 1)];
    }

    public EntityPixieCharge(EntityType<? extends Fireball> t, Level worldIn, double posX, double posY, double posZ, double accelX, double accelY, double accelZ) {
        super(t, posX, posY, posZ, new Vec3(accelX, accelY, accelZ), worldIn);
        this.rgb = EntityPixie.PARTICLE_RGB[this.random.nextInt(EntityPixie.PARTICLE_RGB.length - 1)];
    }

    public EntityPixieCharge(EntityType<? extends Fireball> t, Level worldIn, Player shooter, double accelX, double accelY, double accelZ) {
        super(t, (LivingEntity)shooter, new Vec3(accelX, accelY, accelZ), worldIn);
        this.rgb = EntityPixie.PARTICLE_RGB[this.random.nextInt(EntityPixie.PARTICLE_RGB.length - 1)];
    }

    protected boolean shouldBurn() {
        return false;
    }

    public boolean isPickable() {
        return false;
    }

    public void tick() {
        Entity shootingEntity = this.getOwner();
        if (this.level().isClientSide) {
            for (int i = 0; i < 5; ++i) {
                this.level().addParticle((ParticleOptions)IafParticles.PIXIE_DUST.get(), this.getX() + this.random.nextDouble() * (double)0.15f * (double)(this.random.nextBoolean() ? -1 : 1), this.getY() + this.random.nextDouble() * (double)0.15f * (double)(this.random.nextBoolean() ? -1 : 1), this.getZ() + this.random.nextDouble() * (double)0.15f * (double)(this.random.nextBoolean() ? -1 : 1), (double)this.rgb[0], (double)this.rgb[1], (double)this.rgb[2]);
            }
        }
        this.clearFire();
        if (this.tickCount > 30) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.level().isClientSide || (shootingEntity == null || shootingEntity.isAlive()) && this.level().hasChunkAt(this.blockPosition())) {
            this.baseTick();
            if (this.shouldBurn()) {
                this.igniteForSeconds(1.0f);
            }
            ++this.ticksInAir;
            HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
            if (raytraceresult.getType() != HitResult.Type.MISS) {
                this.onHit(raytraceresult);
            }
            Vec3 vector3d = this.getDeltaMovement();
            double d0 = this.getX() + vector3d.x;
            double d1 = this.getY() + vector3d.y;
            double d2 = this.getZ() + vector3d.z;
            ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.2f);
            float f = this.getInertia();
            this.setDeltaMovement(vector3d.add(vector3d.normalize().multiply(this.stuckSpeedMultiplier)).scale((double)f));
            ++this.ticksInAir;
            if (this.isInWater()) {
                for (int i = 0; i < 4; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - this.getDeltaMovement().x * 0.25, this.getY() - this.getDeltaMovement().y * 0.25, this.getZ() - this.getDeltaMovement().z * 0.25, this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
                }
            }
            this.setPos(d0, d1, d2);
            this.setPos(this.getX(), this.getY(), this.getZ());
        }
    }

    protected void onHit(HitResult movingObject) {
        boolean flag = false;
        Entity shootingEntity = this.getOwner();
        if (!this.level().isClientSide && movingObject.getType() == HitResult.Type.ENTITY && !((EntityHitResult)movingObject).getEntity().is(shootingEntity)) {
            Entity entity = ((EntityHitResult)movingObject).getEntity();
            if (shootingEntity != null && shootingEntity.equals((Object)entity)) {
                flag = true;
            } else {
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    living.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 100, 0));
                    living.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 0));
                    entity.hurt(this.level().damageSources().indirectMagic(shootingEntity, null), 5.0f);
                }
                if (this.level().isClientSide) {
                    for (int i = 0; i < 20; ++i) {
                        this.level().addParticle((ParticleOptions)IafParticles.PIXIE_DUST.get(), this.getX() + this.random.nextDouble() * 1.0 * (double)(this.random.nextBoolean() ? -1 : 1), this.getY() + this.random.nextDouble() * 1.0 * (double)(this.random.nextBoolean() ? -1 : 1), this.getZ() + this.random.nextDouble() * 1.0 * (double)(this.random.nextBoolean() ? -1 : 1), (double)this.rgb[0], (double)this.rgb[1], (double)this.rgb[2]);
                    }
                }
                if (!(shootingEntity instanceof Player && ((Player)shootingEntity).isCreative() || this.random.nextInt(3) != 0)) {
                    this.spawnAtLocation(new ItemStack((ItemLike)IafItems.PIXIE_DUST.get(), 1), 0.45f);
                }
            }
            if (!flag && this.tickCount > 4) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

