/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.impl.ComponentManager;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafWorld;
import com.iafenvoy.iceandfire.world.processor.DreadPortalProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class PortalData {
    private final Player player;
    private boolean teleported = false;
    private int teleportTick = -1;

    public PortalData(Player player) {
        this.player = player;
    }

    public void tick() {
        Level world = this.player.level();
        if (!this.teleported && this.teleportTick == 0 && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            this.teleported = true;
            MinecraftServer server = serverWorld.getServer();
            if (world.dimension().location().equals((Object)IafWorld.DREAD_LAND.location())) {
                this.player.changeDimension(new DimensionTransition(server.overworld(), this.player.position(), Vec3.ZERO, this.player.yHeadRot, this.player.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND));
            } else {
                ServerLevel dreadLand = server.getLevel(IafWorld.DREAD_LAND);
                if (dreadLand == null) {
                    return;
                }
                this.player.changeDimension(new DimensionTransition(server.getLevel(IafWorld.DREAD_LAND), this.player.position(), Vec3.ZERO, this.player.yHeadRot, this.player.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND));
                if (!dreadLand.getBlockState(this.player.blockPosition()).is((Block)IafBlocks.DREAD_PORTAL.get())) {
                    server.getStructureManager().get(ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_exit_portal")).ifPresent(structureTemplate -> structureTemplate.placeInWorld((ServerLevelAccessor)dreadLand, this.player.blockPosition().subtract((Vec3i)new BlockPos(2, 1, 2)), BlockPos.ZERO, new StructurePlaceSettings().addProcessor((StructureProcessor)new DreadPortalProcessor()), dreadLand.random, 2));
                }
                this.player.sendSystemMessage((Component)Component.translatable((String)"warning.iceandfire.dreadland.not_complete"));
            }
        }
        if (world.getBlockState(this.player.blockPosition()).is((Block)IafBlocks.DREAD_PORTAL.get())) {
            if (this.teleportTick > 0) {
                --this.teleportTick;
            } else if (this.teleportTick == -1) {
                this.teleportTick = 100;
            }
        } else {
            this.teleported = false;
            this.teleportTick = -1;
        }
    }

    public void readFromNbt(CompoundTag tag) {
        this.setTeleported(tag.getBoolean("teleported"));
        this.setTeleportTick(tag.getInt("teleport_tick"));
    }

    public void writeToNbt(CompoundTag tag) {
        tag.putBoolean("teleported", this.isTeleported());
        tag.putInt("teleport_tick", this.getTeleportTick());
    }

    public boolean isTeleported() {
        return this.teleported;
    }

    public int getTeleportTick() {
        return this.teleportTick;
    }

    public void setTeleported(boolean teleported) {
        this.teleported = teleported;
    }

    public void setTeleportTick(int teleportTick) {
        this.teleportTick = teleportTick;
    }

    public static PortalData get(Player player) {
        return ComponentManager.getPortalData(player);
    }
}

