/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.common.block.ProductiveFruitBlock;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.loot.CanItemPerformAbility;
import org.jetbrains.annotations.NotNull;

public class LootDataProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final List<LootTableProvider.SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootDataProvider(PackOutput output, List<LootTableProvider.SubProviderEntry> providers, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "loot_table");
        this.subProviders = providers;
        this.registries = registries;
    }

    public String getName() {
        return "Productive Trees Block Loot Table datagen";
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        return this.registries.thenCompose(provider -> this.run(pOutput, (HolderLookup.Provider)provider));
    }

    private CompletableFuture<?> run(CachedOutput pOutput, HolderLookup.Provider pProvider) {
        HashMap map = Maps.newHashMap();
        this.subProviders.forEach(providerEntry -> ((LootTableSubProvider)providerEntry.provider().apply(pProvider)).generate((resourceKey, builder) -> {
            builder.setRandomSequence(resourceKey.location());
            if (map.put(resourceKey.location(), builder.setParamSet(providerEntry.paramSet()).build()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(resourceKey.location()));
            }
        }));
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)pProvider, (Codec)LootTable.DIRECT_CODEC, (Object)((LootTable)entry.getValue()), (Path)this.pathProvider.json((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static class LootProvider
    extends BlockLootSubProvider {
        private static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
        private static final float[] JUNGLE_LEAVES_SAPLING_CHANGES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};
        private static final float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};
        private static final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();
        private static final LootItemCondition.Builder SHEARS_DIG = CanItemPerformAbility.canItemPerformAbility((ItemAbility)ItemAbilities.SHEARS_DIG);
        private static LootItemCondition.Builder SILK_TOUCH;
        private static LootItemCondition.Builder SHEARS_OR_SILK;
        private final List<Block> knownBlocks = new ArrayList<Block>();

        public LootProvider(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            SILK_TOUCH = this.hasSilkTouch();
            SHEARS_OR_SILK = SHEARS_DIG.or(SILK_TOUCH);
            this.dropSelf((Block)TreeRegistrator.SAWMILL.get());
            this.dropSelf((Block)TreeRegistrator.STRIPPER.get());
            this.dropSelf((Block)TreeRegistrator.WOOD_WORKER.get());
            this.dropSelf((Block)TreeRegistrator.POLLEN_SIFTER.get());
            this.dropSelf((Block)TreeRegistrator.TIME_TRAVELLER_DISPLAY.get());
            this.dropSelf((Block)TreeRegistrator.COCONUT_SPROUT.get());
            TreeFinder.trees.forEach((id, treeObject) -> {
                float[] saplingChance = treeObject.getStyle().saplingStyle().equals("jungle") ? JUNGLE_LEAVES_SAPLING_CHANGES : NORMAL_LEAVES_SAPLING_CHANCES;
                this.add(TreeUtil.getBlock(id, "_leaves"), (Block leaf) -> this.createOptionalLeavesDrops((Block)leaf, TreeUtil.getBlock(id, "_sapling"), saplingChance));
                if (treeObject.hasFruit()) {
                    this.add(TreeUtil.getBlock(id, "_fruit"), (Block leaf) -> this.createFruitLeavesDrops((Block)leaf, TreeUtil.getBlock(id, "_sapling"), treeObject.getFruit().getItem().getItem(), saplingChance));
                }
                this.dropSelf(TreeUtil.getBlock(id, "_sapling"));
                this.dropSelf(TreeUtil.getBlock(id, "_log"));
                this.dropSelf(TreeUtil.getBlock(id, "_planks"));
                this.dropSelf(TreeUtil.getBlock(id, "_wood"));
                this.dropSelf(TreeUtil.getBlock(id, "_stripped_log"));
                this.dropSelf(TreeUtil.getBlock(id, "_stripped_wood"));
                if (!ProductiveTrees.isMinimal) {
                    this.dropSelf(TreeUtil.getBlock(id, "_slab"));
                    this.dropSelf(TreeUtil.getBlock(id, "_stairs"));
                    this.dropSelf(TreeUtil.getBlock(id, "_fence"));
                    this.dropSelf(TreeUtil.getBlock(id, "_fence_gate"));
                    this.dropSelf(TreeUtil.getBlock(id, "_pressure_plate"));
                    this.dropSelf(TreeUtil.getBlock(id, "_button"));
                    this.dropDoor(TreeUtil.getBlock(id, "_door"));
                    this.dropSelf(TreeUtil.getBlock(id, "_trapdoor"));
                    this.add(TreeUtil.getBlock(id, "_bookshelf"), this.createSingleItemTableWithSilkTouch(TreeUtil.getBlock(id, "_bookshelf"), (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
                    this.dropSelf(TreeUtil.getBlock(id, "_sign"));
                    this.dropOther(TreeUtil.getBlock(id, "_wall_sign"), (ItemLike)TreeUtil.getBlock(id, "_sign"));
                    this.dropSelf(TreeUtil.getBlock(id, "_hanging_sign"));
                    this.dropOther(TreeUtil.getBlock(id, "_wall_hanging_sign"), (ItemLike)TreeUtil.getBlock(id, "_hanging_sign"));
                }
            });
            TreeRegistrator.CRATED_CROPS.forEach(cratePath -> this.dropSelf((Block)BuiltInRegistries.BLOCK.get(cratePath)));
        }

        protected void add(Block block, LootTable.Builder builder) {
            super.add(block, builder);
            this.knownBlocks.add(block);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }

        protected void add(Block block, Function<Block, LootTable.Builder> builderFunction) {
            this.add(block, builderFunction.apply(block));
        }

        public void dropSelf(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, LootProvider::genOptionalBlockDrop);
            this.add(block, func.apply(block));
        }

        public void dropDoor(@NotNull Block block) {
            this.add(block, (Block x$0) -> this.createDoorTable((Block)x$0));
        }

        @NotNull
        protected LootTable.Builder createOptionalLeavesDrops(Block block, Block sapling, float ... dropChances) {
            HolderLookup.RegistryLookup registryLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return this.createSilkTouchOrShearsDispatchTable(block, ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)sapling).when(ExplosionCondition.survivesExplosion())).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE), (float[])dropChances))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(SHEARS_OR_SILK.invert()).add(LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_STICK_CHANCES))));
        }

        @NotNull
        protected LootTable.Builder createSilkTouchOrShearsDispatchTable(Block block, LootPoolEntryContainer.Builder<?> builder) {
            return this.createSelfDispatchTable(block, SHEARS_OR_SILK, builder);
        }

        @NotNull
        protected LootTable.Builder createFruitLeavesDrops(Block block, Block sapling, Item fruit, float ... dropChances) {
            HolderLookup.RegistryLookup registryLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)sapling).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE), (float[])dropChances))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_STICK_CHANCES)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)fruit).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)ProductiveFruitBlock.getAgeProperty(), ProductiveFruitBlock.getMaxAge())))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay())));
        }

        @NotNull
        protected LootTable.Builder createSelfDispatchTable(Block block, LootItemCondition.Builder conditions, LootPoolEntryContainer.Builder<?> alternative) {
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(conditions)).otherwise(alternative)));
        }

        protected static LootTable.Builder genOptionalBlockDrop(Block block) {
            LootPoolEntryContainer.Builder builder = LootItem.lootTableItem((ItemLike)block).when(ExplosionCondition.survivesExplosion());
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(builder));
        }
    }
}

