/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.event;

import com.mrh0.createaddition.event.ResourceReloadListener;
import com.mrh0.createaddition.item.WireSpool;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.mrh0.createaddition.util.ClientMinecraftWrapper;
import com.mrh0.createaddition.util.Util;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;

@EventBusSubscriber(modid="createaddition", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientEventHandler {
    public static boolean clientRenderHeldWire = false;

    @SubscribeEvent
    public static void playerRendererEvent(ClientTickEvent.Post evt) {
        if (ClientMinecraftWrapper.getPlayer() == null) {
            return;
        }
        ItemStack stack = ClientMinecraftWrapper.getPlayer().getInventory().getSelected();
        if (stack.isEmpty()) {
            return;
        }
        if (WireSpool.isRemover(stack.getItem())) {
            return;
        }
        clientRenderHeldWire = Util.getWireNodeOfSpools(stack) != null;
    }

    @SubscribeEvent
    public static void tickSoundscapes(ClientTickEvent.Post event) {
        CASoundScapes.tick();
    }

    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerReloadListener(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)new ResourceReloadListener());
        }
    }
}

