/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.towntalk.generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class DefaultSoundProvider
implements DataProvider {
    private static final String GENERAL_PREFIX = "general";
    private static final String CRAFTER_PREFIX = "crafter";
    private static final String EMPLOYED_PREFIX = "employed";
    private final DataGenerator generator;
    private final List<DirectorySpec> directoriesToTraverse;

    public DefaultSoundProvider(DataGenerator generator) {
        this.generator = generator;
        this.directoriesToTraverse = List.of(new DirectorySpec("builder", true, false), new DirectorySpec("deliveryman", true, false), new DirectorySpec("miner", true, false), new DirectorySpec("lumberjack", true, false), new DirectorySpec("farmer", true, false), new DirectorySpec("undertaker", true, false), new DirectorySpec("fisherman", true, false), new DirectorySpec("baker", true, true), new DirectorySpec("cook", true, true), new DirectorySpec("shepherd", true, false), new DirectorySpec("cowboy", true, false), new DirectorySpec("swineherder", true, false), new DirectorySpec("chickenherder", true, false), new DirectorySpec("smelter", true, true), new DirectorySpec("ranger", true, false), new DirectorySpec("knight", true, false), new DirectorySpec("composter", true, false), new DirectorySpec("student", true, false), new DirectorySpec("archertraining", true, false), new DirectorySpec("combattraining", true, false), new DirectorySpec("sawmill", true, true), new DirectorySpec("blacksmith", true, true), new DirectorySpec("stonemason", true, true), new DirectorySpec("stonesmeltery", true, true), new DirectorySpec("crusher", true, true), new DirectorySpec("sifter", true, false), new DirectorySpec("florist", true, false), new DirectorySpec("enchanter", true, false), new DirectorySpec("researcher", true, false), new DirectorySpec("healer", true, false), new DirectorySpec("pupil", true, false), new DirectorySpec("teacher", true, false), new DirectorySpec("glassblower", true, true), new DirectorySpec("dyer", true, true), new DirectorySpec("fletcher", true, true), new DirectorySpec("mechanic", true, true), new DirectorySpec("planter", true, false), new DirectorySpec("rabbitherder", true, false), new DirectorySpec("concretemixer", true, true), new DirectorySpec("beekeeper", true, false), new DirectorySpec("cookassistant", true, true), new DirectorySpec("netherworker", true, false), new DirectorySpec("quarrier", true, false), new DirectorySpec("druid", true, false), new DirectorySpec("alchemist", true, true), new DirectorySpec("visitor", false, false), new DirectorySpec("chef", false, false), new DirectorySpec("unemployed", false, false));
    }

    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        JsonObject sounds = new JsonObject();
        Path outputFolder = this.generator.getPackOutput().getOutputFolder();
        Path sourceFolder = outputFolder.getParent().getParent().resolve("main/resources/respack/assets/minecolonies/sounds");
        try (Stream<Path> genders = Files.list(sourceFolder);){
            for (Path gender : genders.toList()) {
                String genderName = sourceFolder.relativize(gender).toString();
                HashMap<String, List<Path>> generalCategories = new HashMap<String, List<Path>>();
                this.parseCategories(gender.resolve(GENERAL_PREFIX), generalCategories);
                for (DirectorySpec spec : this.directoriesToTraverse) {
                    Map<String, List<Path>> allCategories = generalCategories.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue())));
                    if (Files.exists(gender.resolve(spec.name), new LinkOption[0])) {
                        this.parseCategories(gender.resolve(spec.name), allCategories);
                    }
                    if (spec.isJob) {
                        this.parseCategories(gender.resolve(EMPLOYED_PREFIX), allCategories);
                    }
                    if (spec.isCrafter) {
                        this.parseCategories(gender.resolve(CRAFTER_PREFIX), allCategories);
                    }
                    for (Map.Entry<String, List<Path>> entry : allCategories.entrySet()) {
                        JsonArray soundsArray = new JsonArray();
                        for (Path soundPath : entry.getValue()) {
                            ResourceLocation soundId = ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)FilenameUtils.removeExtension((String)sourceFolder.relativize(soundPath).toString()).replace('\\', '/'));
                            JsonObject soundArrayItem = new JsonObject();
                            soundArrayItem.addProperty("name", soundId.toString());
                            soundArrayItem.addProperty("stream", Boolean.valueOf(false));
                            soundsArray.add((JsonElement)soundArrayItem);
                        }
                        JsonObject soundObject = new JsonObject();
                        soundObject.addProperty("category", "neutral");
                        soundObject.addProperty("replace", Boolean.valueOf(true));
                        soundObject.add("sounds", (JsonElement)soundsArray);
                        sounds.add("citizen." + spec.name + "." + genderName + "." + entry.getKey(), (JsonElement)soundObject);
                    }
                }
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)sounds, (Path)outputFolder.resolve("respack/assets/minecolonies/sounds.json"));
    }

    @NotNull
    public String getName() {
        return "Default Sound Json Provider";
    }

    private void parseCategories(Path root, Map<String, List<Path>> target) throws IOException {
        try (Stream<Path> sounds = Files.walk(root, new FileVisitOption[0]);){
            for (Path sound : sounds.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList()) {
                Path relative = root.relativize(sound);
                String[] split = relative.toString().split(Pattern.quote(File.separator));
                if (split.length == 1) {
                    target.putIfAbsent(GENERAL_PREFIX, new ArrayList());
                    target.get(GENERAL_PREFIX).add(sound);
                    continue;
                }
                if (split.length <= 1) continue;
                target.putIfAbsent(split[0], new ArrayList());
                target.get(split[0]).add(sound);
            }
        }
    }

    private record DirectorySpec(String name, boolean isJob, boolean isCrafter) {
    }
}

