/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.datagen.recipe;

import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterBlock;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerBlock;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorBlock;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridBlock;
import com.refinedmods.refinedstorage.common.constructordestructor.ConstructorBlock;
import com.refinedmods.refinedstorage.common.constructordestructor.DestructorBlock;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.content.Tags;
import com.refinedmods.refinedstorage.common.controller.AbstractControllerBlock;
import com.refinedmods.refinedstorage.common.detector.DetectorBlock;
import com.refinedmods.refinedstorage.common.exporter.ExporterBlock;
import com.refinedmods.refinedstorage.common.grid.CraftingGridBlock;
import com.refinedmods.refinedstorage.common.grid.GridBlock;
import com.refinedmods.refinedstorage.common.importer.ImporterBlock;
import com.refinedmods.refinedstorage.common.networking.CableBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkReceiverBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterBlock;
import com.refinedmods.refinedstorage.common.networking.RelayBlock;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterBlock;
import com.refinedmods.refinedstorage.common.security.SecurityManagerBlock;
import com.refinedmods.refinedstorage.common.storage.diskinterface.DiskInterfaceBlock;
import com.refinedmods.refinedstorage.common.storage.externalstorage.ExternalStorageBlock;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class RecoloringRecipeProvider
extends RecipeProvider {
    public RecoloringRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput output) {
        Blocks.INSTANCE.getCable().forEach((color, id, block) -> this.recipe(Tags.CABLES, ((CableBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "cable")));
        Blocks.INSTANCE.getImporter().forEach((color, id, block) -> this.recipe(Tags.IMPORTERS, ((ImporterBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "importer")));
        Blocks.INSTANCE.getExporter().forEach((color, id, block) -> this.recipe(Tags.EXPORTERS, ((ExporterBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "exporter")));
        Blocks.INSTANCE.getExternalStorage().forEach((color, id, block) -> this.recipe(Tags.EXTERNAL_STORAGES, ((ExternalStorageBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "external_storage")));
        Blocks.INSTANCE.getController().forEach((color, id, block) -> this.recipe(Tags.CONTROLLERS, ((AbstractControllerBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "controller")));
        Blocks.INSTANCE.getGrid().forEach((color, id, block) -> this.recipe(Tags.GRIDS, ((GridBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "grid")));
        Blocks.INSTANCE.getCraftingGrid().forEach((color, id, block) -> this.recipe(Tags.CRAFTING_GRIDS, ((CraftingGridBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "crafting_grid")));
        Blocks.INSTANCE.getPatternGrid().forEach((color, id, block) -> this.recipe(Tags.PATTERN_GRIDS, ((PatternGridBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "pattern_grid")));
        Blocks.INSTANCE.getDetector().forEach((color, id, block) -> this.recipe(Tags.DETECTORS, ((DetectorBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "detector")));
        Blocks.INSTANCE.getConstructor().forEach((color, id, block) -> this.recipe(Tags.CONSTRUCTORS, ((ConstructorBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "constructor")));
        Blocks.INSTANCE.getDestructor().forEach((color, id, block) -> this.recipe(Tags.DESTRUCTORS, ((DestructorBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "destructor")));
        Blocks.INSTANCE.getWirelessTransmitter().forEach((color, id, block) -> this.recipe(Tags.WIRELESS_TRANSMITTERS, ((WirelessTransmitterBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "wireless_transmitter")));
        Blocks.INSTANCE.getNetworkReceiver().forEach((color, id, block) -> this.recipe(Tags.NETWORK_RECEIVERS, ((NetworkReceiverBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "network_receiver")));
        Blocks.INSTANCE.getNetworkTransmitter().forEach((color, id, block) -> this.recipe(Tags.NETWORK_TRANSMITTERS, ((NetworkTransmitterBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "network_transmitter")));
        Blocks.INSTANCE.getSecurityManager().forEach((color, id, block) -> this.recipe(Tags.SECURITY_MANAGERS, ((SecurityManagerBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "security_manager")));
        Blocks.INSTANCE.getRelay().forEach((color, id, block) -> this.recipe(Tags.RELAYS, ((RelayBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "relay")));
        Blocks.INSTANCE.getDiskInterface().forEach((color, id, block) -> this.recipe(Tags.DISK_INTERFACES, ((DiskInterfaceBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "disk_interface")));
        Blocks.INSTANCE.getAutocrafter().forEach((color, id, block) -> this.recipe(Tags.AUTOCRAFTERS, ((AutocrafterBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "autocrafter")));
        Blocks.INSTANCE.getAutocrafterManager().forEach((color, id, block) -> this.recipe(Tags.AUTOCRAFTER_MANAGERS, ((AutocrafterManagerBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "autocrafter_manager")));
        Blocks.INSTANCE.getAutocraftingMonitor().forEach((color, id, block) -> this.recipe(Tags.AUTOCRAFTING_MONITORS, ((AutocraftingMonitorBlock)block.get()).asItem(), color).save(output, this.recipeId(color, "autocrafting_monitor")));
    }

    private ResourceLocation recipeId(DyeColor color, String suffix) {
        return IdentifierUtil.createIdentifier("coloring/" + color.getName() + "_" + suffix);
    }

    private ShapelessRecipeBuilder recipe(TagKey<Item> dyeable, Item result, DyeColor color) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).requires(dyeable).requires(RecoloringRecipeProvider.getDyeTag(color)).unlockedBy("has_" + dyeable.location().getPath(), RecoloringRecipeProvider.has(dyeable));
    }

    private static TagKey<Item> getDyeTag(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.RED -> Tags.Items.DYES_RED;
            case DyeColor.WHITE -> Tags.Items.DYES_WHITE;
            case DyeColor.ORANGE -> Tags.Items.DYES_ORANGE;
            case DyeColor.MAGENTA -> Tags.Items.DYES_MAGENTA;
            case DyeColor.LIGHT_BLUE -> Tags.Items.DYES_LIGHT_BLUE;
            case DyeColor.YELLOW -> Tags.Items.DYES_YELLOW;
            case DyeColor.LIME -> Tags.Items.DYES_LIME;
            case DyeColor.PINK -> Tags.Items.DYES_PINK;
            case DyeColor.GRAY -> Tags.Items.DYES_GRAY;
            case DyeColor.LIGHT_GRAY -> Tags.Items.DYES_LIGHT_GRAY;
            case DyeColor.CYAN -> Tags.Items.DYES_CYAN;
            case DyeColor.PURPLE -> Tags.Items.DYES_PURPLE;
            case DyeColor.BLUE -> Tags.Items.DYES_BLUE;
            case DyeColor.BROWN -> Tags.Items.DYES_BROWN;
            case DyeColor.GREEN -> Tags.Items.DYES_GREEN;
            case DyeColor.BLACK -> Tags.Items.DYES_BLACK;
        };
    }
}

