/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.datagen;

import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterBlock;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerBlock;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorBlock;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridBlock;
import com.refinedmods.refinedstorage.common.constructordestructor.ConstructorBlock;
import com.refinedmods.refinedstorage.common.constructordestructor.DestructorBlock;
import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.content.ContentIds;
import com.refinedmods.refinedstorage.common.controller.AbstractControllerBlock;
import com.refinedmods.refinedstorage.common.controller.ControllerBlockItem;
import com.refinedmods.refinedstorage.common.controller.CreativeControllerBlockItem;
import com.refinedmods.refinedstorage.common.detector.DetectorBlock;
import com.refinedmods.refinedstorage.common.exporter.ExporterBlock;
import com.refinedmods.refinedstorage.common.grid.CraftingGridBlock;
import com.refinedmods.refinedstorage.common.grid.GridBlock;
import com.refinedmods.refinedstorage.common.importer.ImporterBlock;
import com.refinedmods.refinedstorage.common.networking.CableBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkReceiverBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterBlock;
import com.refinedmods.refinedstorage.common.networking.RelayBlock;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterBlock;
import com.refinedmods.refinedstorage.common.security.SecurityManagerBlock;
import com.refinedmods.refinedstorage.common.storage.diskinterface.DiskInterfaceBlock;
import com.refinedmods.refinedstorage.common.storage.externalstorage.ExternalStorageBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.neoforge.datagen.ColoredCustomLoaderBuilder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModelProviderImpl
extends ItemModelProvider {
    private static final String CUTOUT_TEXTURE_KEY = "cutout";
    private static final String CABLE_TEXTURE_KEY = "cable";

    public ItemModelProviderImpl(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "refinedstorage", existingFileHelper);
    }

    protected void registerModels() {
        this.registerCables();
        this.registerExporters();
        this.registerImporters();
        this.registerExternalStorages();
        this.registerControllers();
        this.registerCreativeControllers();
        this.registerGrids();
        this.registerCraftingGrids();
        this.registerPatternGrids();
        this.registerDetectors();
        this.registerConstructors();
        this.registerDestructors();
        this.registerWirelessTransmitters();
        this.registerNetworkReceivers();
        this.registerNetworkTransmitters();
        this.registerSecurityManagers();
        this.registerRelays();
        this.registerDiskInterfaces();
        this.registerAutocrafters();
        this.registerAutocrafterManagers();
        this.registerAutocraftingMonitors();
    }

    private void registerCables() {
        ResourceLocation base = IdentifierUtil.createIdentifier("item/cable/base");
        BlockColorMap<CableBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getCable();
        blocks.forEach((color, id, block) -> this.addCableTexture(color, id, base));
    }

    private void registerExporters() {
        ResourceLocation base = IdentifierUtil.createIdentifier("item/exporter/base");
        BlockColorMap<ExporterBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getExporter();
        blocks.forEach((color, id, block) -> this.addCableTexture(color, id, base));
    }

    private void registerImporters() {
        ResourceLocation base = IdentifierUtil.createIdentifier("item/importer/base");
        BlockColorMap<ImporterBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getImporter();
        blocks.forEach((color, id, block) -> this.addCableTexture(color, id, base));
    }

    private void registerExternalStorages() {
        ResourceLocation base = IdentifierUtil.createIdentifier("item/external_storage/base");
        BlockColorMap<ExternalStorageBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getExternalStorage();
        blocks.forEach((color, id, block) -> this.addCableTexture(color, id, base));
    }

    private void registerControllers() {
        ResourceLocation base = ResourceLocation.withDefaultNamespace((String)"item/generated");
        ResourceLocation off = IdentifierUtil.createIdentifier("block/controller/off");
        ResourceLocation nearlyOff = IdentifierUtil.createIdentifier("block/controller/nearly_off");
        ResourceLocation nearlyOn = IdentifierUtil.createIdentifier("block/controller/nearly_on");
        ResourceLocation stored = IdentifierUtil.createIdentifier("stored_in_controller");
        BlockColorMap<AbstractControllerBlock<ControllerBlockItem>, ControllerBlockItem> blocks = Blocks.INSTANCE.getController();
        blocks.forEach((color, id, block) -> ((ItemModelBuilder)this.withExistingParent(id.getPath(), base)).override().predicate(stored, 0.0f).model(this.modelFile(off)).end().override().predicate(stored, 0.01f).model(this.modelFile(nearlyOff)).end().override().predicate(stored, 0.3f).model(this.modelFile(nearlyOn)).end().override().predicate(stored, 0.4f).model(this.modelFile(IdentifierUtil.createIdentifier("block/controller/" + color.getName()))).end());
    }

    private void registerCreativeControllers() {
        BlockColorMap<AbstractControllerBlock<CreativeControllerBlockItem>, CreativeControllerBlockItem> blocks = Blocks.INSTANCE.getCreativeController();
        blocks.forEach((color, id, block) -> this.withExistingParent(id.getPath(), IdentifierUtil.createIdentifier("block/controller/" + color.getName())));
    }

    private void registerGrids() {
        BlockColorMap<GridBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getGrid();
        blocks.forEach((color, id, block) -> this.withExistingParent(id.getPath(), IdentifierUtil.createIdentifier("block/grid/" + color.getName())));
    }

    private void registerCraftingGrids() {
        BlockColorMap<CraftingGridBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getCraftingGrid();
        blocks.forEach((color, id, block) -> this.withExistingParent(id.getPath(), IdentifierUtil.createIdentifier("block/crafting_grid/" + color.getName())));
    }

    private void registerPatternGrids() {
        BlockColorMap<PatternGridBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getPatternGrid();
        blocks.forEach((color, id, block) -> this.withExistingParent(id.getPath(), IdentifierUtil.createIdentifier("block/pattern_grid/" + color.getName())));
    }

    private void registerDetectors() {
        BlockColorMap<DetectorBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getDetector();
        blocks.forEach((color, id, block) -> this.withExistingParent(id.getPath(), IdentifierUtil.createIdentifier("block/detector/" + color.getName())));
    }

    private void registerConstructors() {
        ResourceLocation base = IdentifierUtil.createIdentifier("item/constructor/base");
        BlockColorMap<ConstructorBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getConstructor();
        blocks.forEach((color, id, block) -> this.addCableTexture(color, id, base));
    }

    private void registerDestructors() {
        ResourceLocation base = IdentifierUtil.createIdentifier("item/destructor/base");
        BlockColorMap<DestructorBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getDestructor();
        blocks.forEach((color, id, block) -> this.addCableTexture(color, id, base));
    }

    private void registerWirelessTransmitters() {
        ResourceLocation base = IdentifierUtil.createIdentifier("block/wireless_transmitter/inactive");
        BlockColorMap<WirelessTransmitterBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getWirelessTransmitter();
        blocks.forEach((color, id, block) -> this.singleTexture(id.getPath(), base, CUTOUT_TEXTURE_KEY, IdentifierUtil.createIdentifier("block/wireless_transmitter/cutouts/" + color.getName())));
    }

    private void registerNetworkReceivers() {
        ResourceLocation base = IdentifierUtil.createIdentifier("block/network_receiver/inactive");
        BlockColorMap<NetworkReceiverBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getNetworkReceiver();
        blocks.forEach((color, id, block) -> this.singleTexture(id.getPath(), base, CUTOUT_TEXTURE_KEY, IdentifierUtil.createIdentifier("block/network_receiver/cutouts/" + color.getName())));
    }

    private void registerNetworkTransmitters() {
        ResourceLocation base = IdentifierUtil.createIdentifier("block/network_transmitter/inactive");
        BlockColorMap<NetworkTransmitterBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getNetworkTransmitter();
        blocks.forEach((color, id, block) -> this.singleTexture(id.getPath(), base, CUTOUT_TEXTURE_KEY, IdentifierUtil.createIdentifier("block/network_transmitter/cutouts/" + color.getName())));
    }

    private void registerSecurityManagers() {
        BlockColorMap<SecurityManagerBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getSecurityManager();
        blocks.forEach((color, id, block) -> this.withExistingParent(id.getPath(), IdentifierUtil.createIdentifier("block/security_manager/" + color.getName())));
    }

    private void registerRelays() {
        BlockColorMap<RelayBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getRelay();
        blocks.forEach((color, id, block) -> this.withExistingParent(id.getPath(), IdentifierUtil.createIdentifier("block/relay/" + color.getName())));
    }

    private void registerDiskInterfaces() {
        BlockColorMap<DiskInterfaceBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getDiskInterface();
        blocks.forEach((color, id, block) -> ((ColoredCustomLoaderBuilder)((ItemModelBuilder)this.getBuilder(id.getPath())).customLoader((blockModelBuilder, existingFileHelper) -> new ColoredCustomLoaderBuilder<ItemModelBuilder>(this, ContentIds.DISK_INTERFACE, blockModelBuilder, existingFileHelper, color){})).end());
    }

    private void registerAutocrafters() {
        BlockColorMap<AutocrafterBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getAutocrafter();
        blocks.forEach((color, id, block) -> this.withExistingParent(id.getPath(), IdentifierUtil.createIdentifier("block/autocrafter/" + color.getName())));
    }

    private void registerAutocrafterManagers() {
        BlockColorMap<AutocrafterManagerBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getAutocrafterManager();
        blocks.forEach((color, id, block) -> this.withExistingParent(id.getPath(), IdentifierUtil.createIdentifier("block/autocrafter_manager/" + color.getName())));
    }

    private void registerAutocraftingMonitors() {
        BlockColorMap<AutocraftingMonitorBlock, BaseBlockItem> blocks = Blocks.INSTANCE.getAutocraftingMonitor();
        blocks.forEach((color, id, block) -> this.withExistingParent(id.getPath(), IdentifierUtil.createIdentifier("block/autocrafting_monitor/" + color.getName())));
    }

    private ModelFile modelFile(ResourceLocation location) {
        return new ModelFile.ExistingModelFile(location, this.existingFileHelper);
    }

    private void addCableTexture(DyeColor color, ResourceLocation id, ResourceLocation base) {
        this.singleTexture(id.getPath(), base, CABLE_TEXTURE_KEY, IdentifierUtil.createIdentifier("block/cable/" + color.getName()));
    }
}

