/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.widget;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.content.KeyMappings;
import com.refinedmods.refinedstorage.common.support.widget.History;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class SearchFieldWidget
extends EditBox {
    private final History history;

    public SearchFieldWidget(Font font, int x, int y, int width, History history) {
        Objects.requireNonNull(font);
        super(font, x, y, width, 9, (Component)Component.empty());
        this.history = history;
        this.setBordered(false);
        this.setMaxLength(256);
        this.setAutoSelected(Platform.INSTANCE.getConfig().isSearchBoxAutoSelected());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean clickedWidget;
        boolean wasFocused = this.isFocused();
        boolean result = super.mouseClicked(mouseX, mouseY, mouseButton);
        boolean bl = clickedWidget = mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
        if (clickedWidget && mouseButton == 1) {
            this.setValue("");
            this.setFocused(true);
        } else if (wasFocused != this.isFocused()) {
            this.saveHistory();
        } else if (!clickedWidget) {
            this.setFocused(false);
        }
        return result;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifier) {
        boolean havingControl;
        boolean canLoseFocus = Platform.INSTANCE.canEditBoxLoseFocus(this);
        boolean bl = havingControl = this.isActive() && this.isFocused();
        if (havingControl && this.shouldMoveControlToParent(keyCode, canLoseFocus)) {
            return false;
        }
        if (Platform.INSTANCE.isKeyDown(KeyMappings.INSTANCE.getFocusSearchBar()) && canLoseFocus) {
            this.toggleFocus();
        }
        super.keyPressed(keyCode, scanCode, modifier);
        return havingControl;
    }

    private boolean shouldMoveControlToParent(int keyCode, boolean canLoseFocus) {
        if (keyCode == 265 || keyCode == 264) {
            String newValue = keyCode == 265 ? this.history.older() : this.history.newer();
            this.setValue(newValue);
        } else if (keyCode == 257 || keyCode == 335) {
            this.saveHistory();
            if (canLoseFocus) {
                this.setFocused(false);
            }
        } else if (keyCode == 256) {
            this.saveHistory();
            this.setFocused(false);
            return !canLoseFocus;
        }
        return false;
    }

    private void toggleFocus() {
        this.setFocused(!this.isFocused());
        this.saveHistory();
    }

    public void setAutoSelected(boolean autoSelected) {
        this.setFocused(autoSelected);
        this.setCanLoseFocus(!autoSelected);
    }

    private void saveHistory() {
        this.history.save(this.getValue());
    }
}

