/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.registry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.common.api.support.registry.PlatformRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class PlatformRegistryImpl<T>
implements PlatformRegistry<T> {
    private static final String VALUE_NOT_PRESENT_ERROR = "Value must be present";
    private static final String ID_NOT_PRESENT_ERROR = "ID must be present";
    private final Map<ResourceLocation, T> idToValueMap = new HashMap<ResourceLocation, T>();
    private final Map<T, ResourceLocation> valueToIdMap = new HashMap<T, ResourceLocation>();
    private final List<T> order = new ArrayList<T>();
    private final List<T> viewList = Collections.unmodifiableList(this.order);
    private final Codec<T> codec = ResourceLocation.CODEC.comapFlatMap(id -> this.get((ResourceLocation)id).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown ID: " + String.valueOf(id))), value -> this.getId(value).orElseThrow());
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = new StreamCodec<RegistryFriendlyByteBuf, T>(){

        public T decode(RegistryFriendlyByteBuf buf) {
            return PlatformRegistryImpl.this.get(buf.readResourceLocation()).orElseThrow();
        }

        public void encode(RegistryFriendlyByteBuf buf, T value) {
            buf.writeResourceLocation(PlatformRegistryImpl.this.getId(value).orElseThrow());
        }
    };

    @Override
    public void register(ResourceLocation id, T value) {
        CoreValidations.validateNotNull(id, ID_NOT_PRESENT_ERROR);
        CoreValidations.validateNotNull(value, VALUE_NOT_PRESENT_ERROR);
        if (this.idToValueMap.containsKey(id) || this.order.contains(value)) {
            throw new IllegalArgumentException("Already registered");
        }
        this.idToValueMap.put(id, value);
        this.valueToIdMap.put(value, id);
        this.order.add(value);
    }

    @Override
    public Optional<ResourceLocation> getId(T value) {
        CoreValidations.validateNotNull(value, VALUE_NOT_PRESENT_ERROR);
        return Optional.ofNullable(this.valueToIdMap.get(value));
    }

    @Override
    public Optional<T> get(ResourceLocation id) {
        CoreValidations.validateNotNull(id, ID_NOT_PRESENT_ERROR);
        return Optional.ofNullable(this.idToValueMap.get(id));
    }

    @Override
    public List<T> getAll() {
        return this.viewList;
    }

    @Override
    @Nullable
    public T nextOrNullIfLast(T value) {
        CoreValidations.validateNotNull(value, VALUE_NOT_PRESENT_ERROR);
        if (this.order.isEmpty()) {
            return null;
        }
        int index = this.order.indexOf(value);
        int nextIndex = index + 1;
        if (nextIndex >= this.order.size()) {
            return null;
        }
        return this.order.get(nextIndex);
    }

    @Override
    public Codec<T> codec() {
        return this.codec;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }
}

