/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.s2c;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record ResourceSlotUpdatePacket(int slotIndex, Optional<ResourceAmount> resourceAmount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ResourceSlotUpdatePacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier("resource_slot_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourceSlotUpdatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ResourceSlotUpdatePacket::slotIndex, (StreamCodec)ByteBufCodecs.optional(ResourceCodecs.AMOUNT_STREAM_CODEC), ResourceSlotUpdatePacket::resourceAmount, ResourceSlotUpdatePacket::new);

    public static void handle(ResourceSlotUpdatePacket packet, PacketContext ctx) {
        AbstractContainerMenu abstractContainerMenu = ctx.getPlayer().containerMenu;
        if (abstractContainerMenu instanceof AbstractResourceContainerMenu) {
            AbstractResourceContainerMenu containerMenu = (AbstractResourceContainerMenu)abstractContainerMenu;
            containerMenu.handleResourceSlotUpdate(packet.slotIndex, packet.resourceAmount.orElse(null));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }
}

