/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.storageblock;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.storage.AbstractStorageContainerBlockItem;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.storage.FluidStorageVariant;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FluidStorageBlockBlockItem
extends AbstractStorageContainerBlockItem
implements UpgradeableStorageContainer {
    private static final Component CREATIVE_HELP = IdentifierUtil.createTranslation("item", "creative_fluid_storage_block.help");
    private final FluidStorageVariant variant;
    private final Component helpText;

    public FluidStorageBlockBlockItem(Block block, FluidStorageVariant variant) {
        super(block, new Item.Properties().stacksTo(1).fireResistant(), RefinedStorageApi.INSTANCE.getStorageContainerItemHelper());
        this.variant = variant;
        this.helpText = FluidStorageBlockBlockItem.getHelpText(variant);
    }

    private static Component getHelpText(FluidStorageVariant variant) {
        if (variant.getCapacityInBuckets() == null) {
            return CREATIVE_HELP;
        }
        return IdentifierUtil.createTranslation("item", "fluid_storage_block.help", IdentifierUtil.format(variant.getCapacityInBuckets()));
    }

    @Override
    @Nullable
    protected Long getCapacity() {
        return this.variant.getCapacity();
    }

    @Override
    protected String formatAmount(long amount) {
        return RefinedStorageClientApi.INSTANCE.getResourceRendering(FluidResource.class).formatAmount(amount);
    }

    @Override
    protected SerializableStorage createStorage(StorageRepository storageRepository) {
        return FluidStorageBlockBlockItem.createStorage(this.variant, storageRepository::markAsChanged);
    }

    static SerializableStorage createStorage(FluidStorageVariant variant, Runnable listener) {
        return StorageTypes.FLUID.create(variant.getCapacity(), listener);
    }

    @Override
    protected ItemStack createPrimaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)Blocks.INSTANCE.getMachineCasing(), count);
    }

    @Override
    @Nullable
    protected ItemStack createSecondaryDisassemblyByproduct(int count) {
        if (this.variant == FluidStorageVariant.CREATIVE) {
            return null;
        }
        return new ItemStack((ItemLike)Items.INSTANCE.getFluidStoragePart(this.variant), count);
    }

    protected boolean placeBlock(BlockPlaceContext ctx, BlockState state) {
        ServerPlayer serverPlayer;
        Player player = ctx.getPlayer();
        if (player instanceof ServerPlayer && !RefinedStorageApi.INSTANCE.canPlaceNetworkNode(serverPlayer = (ServerPlayer)player, ctx.getLevel(), ctx.getClickedPos(), state)) {
            return false;
        }
        return super.placeBlock(ctx, state);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(this.helpText));
    }

    @Override
    public StorageVariant getVariant() {
        return this.variant;
    }

    @Override
    public void transferTo(ItemStack from, ItemStack to) {
        this.helper.markAsToTransfer(from, to);
    }
}

