/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.diskinterface;

import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

class TransferModeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "disk_interface.transfer_mode");
    private static final List<MutableComponent> SUBTEXT_INSERT_INTO_NETWORK = List.of(IdentifierUtil.createTranslation("gui", "disk_interface.transfer_mode.insert_into_network").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_EXTRACT_FROM_NETWORK = List.of(IdentifierUtil.createTranslation("gui", "disk_interface.transfer_mode.extract_from_network").withStyle(ChatFormatting.GRAY));
    private static final Component HELP_INSERT_INTO_NETWORK = IdentifierUtil.createTranslation("gui", "disk_interface.transfer_mode.insert_into_network.help");
    private static final Component HELP_EXTRACT_FROM_NETWORK = IdentifierUtil.createTranslation("gui", "disk_interface.transfer_mode.extract_from_network.help");
    private static final ResourceLocation INSERT_INTO_NETWORK = IdentifierUtil.createIdentifier("widget/side_button/disk_interface_transfer_mode/insert_into_network");
    private static final ResourceLocation EXTRACT_FROM_NETWORK = IdentifierUtil.createIdentifier("widget/side_button/disk_interface_transfer_mode/extract_from_network");
    private final ClientProperty<StorageTransferMode> property;

    TransferModeSideButtonWidget(ClientProperty<StorageTransferMode> property) {
        super(TransferModeSideButtonWidget.createPressAction(property));
        this.property = property;
    }

    private static Button.OnPress createPressAction(ClientProperty<StorageTransferMode> property) {
        return btn -> property.setValue(TransferModeSideButtonWidget.toggle((StorageTransferMode)((Object)((Object)property.getValue()))));
    }

    private static StorageTransferMode toggle(StorageTransferMode accessMode) {
        return switch (accessMode) {
            default -> throw new MatchException(null, null);
            case StorageTransferMode.INSERT_INTO_NETWORK -> StorageTransferMode.EXTRACT_FROM_NETWORK;
            case StorageTransferMode.EXTRACT_FROM_NETWORK -> StorageTransferMode.INSERT_INTO_NETWORK;
        };
    }

    @Override
    protected ResourceLocation getSprite() {
        return switch (this.property.getValue()) {
            default -> throw new MatchException(null, null);
            case StorageTransferMode.INSERT_INTO_NETWORK -> INSERT_INTO_NETWORK;
            case StorageTransferMode.EXTRACT_FROM_NETWORK -> EXTRACT_FROM_NETWORK;
        };
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return switch (this.property.getValue()) {
            default -> throw new MatchException(null, null);
            case StorageTransferMode.INSERT_INTO_NETWORK -> SUBTEXT_INSERT_INTO_NETWORK;
            case StorageTransferMode.EXTRACT_FROM_NETWORK -> SUBTEXT_EXTRACT_FROM_NETWORK;
        };
    }

    @Override
    protected Component getHelpText() {
        return switch (this.property.getValue()) {
            default -> throw new MatchException(null, null);
            case StorageTransferMode.INSERT_INTO_NETWORK -> HELP_INSERT_INTO_NETWORK;
            case StorageTransferMode.EXTRACT_FROM_NETWORK -> HELP_EXTRACT_FROM_NETWORK;
        };
    }
}

