/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.diskdrive;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.StorageInfo;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.storage.AbstractStorageContainerMenu;
import com.refinedmods.refinedstorage.common.storage.StorageAccessor;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainer;
import com.refinedmods.refinedstorage.common.storage.diskdrive.StorageDiskInfoAccessor;
import com.refinedmods.refinedstorage.common.storage.diskdrive.StorageDiskInfoAccessorImpl;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.containermenu.ValidatedSlot;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DiskDriveContainerMenu
extends AbstractStorageContainerMenu
implements StorageAccessor {
    private static final int DISK_SLOT_X = 61;
    private static final int DISK_SLOT_Y = 54;
    private static final int FILTER_SLOT_X = 8;
    private static final int FILTER_SLOT_Y = 20;
    private final StorageDiskInfoAccessor storageInfoAccessor;
    private final List<Slot> diskSlots = new ArrayList<Slot>();
    private final Predicate<Player> stillValid;

    public DiskDriveContainerMenu(int syncId, Inventory playerInventory, ResourceContainerData resourceContainerData) {
        super(Menus.INSTANCE.getDiskDrive(), syncId);
        this.storageInfoAccessor = new StorageDiskInfoAccessorImpl(RefinedStorageApi.INSTANCE.getClientStorageRepository());
        this.addSlots(playerInventory.player, new FilteredContainer(8, StorageContainerItem.stackValidator()), ResourceContainerImpl.createForFilter(resourceContainerData));
        this.stillValid = p -> true;
    }

    DiskDriveContainerMenu(int syncId, Player player, FilteredContainer diskInventory, ResourceContainer filterContainer, StorageConfigurationContainer configContainer, StorageDiskInfoAccessor storageInfoAccessor, Predicate<Player> stillValid) {
        super(Menus.INSTANCE.getDiskDrive(), syncId, player, configContainer);
        this.storageInfoAccessor = storageInfoAccessor;
        this.addSlots(player, diskInventory, filterContainer);
        this.stillValid = stillValid;
    }

    private void addSlots(Player player, FilteredContainer diskInventory, ResourceContainer filterContainer) {
        int i;
        for (i = 0; i < diskInventory.getContainerSize(); ++i) {
            this.diskSlots.add(this.addSlot(this.createDiskSlot(diskInventory, i)));
        }
        for (i = 0; i < filterContainer.size(); ++i) {
            this.addSlot(this.createFilterSlot(filterContainer, i));
        }
        this.addPlayerInventory(player.getInventory(), 8, 141);
        this.transferManager.addBiTransfer((Container)player.getInventory(), (Container)diskInventory);
        this.transferManager.addFilterTransfer((Container)player.getInventory());
    }

    private Slot createFilterSlot(ResourceContainer filterContainer, int i) {
        int x = 8 + 18 * i;
        return new ResourceSlot(filterContainer, i, (Component)IdentifierUtil.createTranslation("gui", "storage.filter_help"), x, 20, ResourceSlotType.FILTER);
    }

    private Slot createDiskSlot(FilteredContainer diskInventory, int i) {
        int x = 61 + i % 2 * 18;
        int y = 54 + Math.floorDiv(i, 2) * 18;
        return ValidatedSlot.forStorageContainer((Container)diskInventory, i, x, y);
    }

    @Override
    public boolean hasCapacity() {
        return this.getStorageDiskInfo().allMatch(info -> info.capacity() > 0L);
    }

    @Override
    public double getProgress() {
        if (!this.hasCapacity()) {
            return 0.0;
        }
        return (double)this.getStored() / (double)this.getCapacity();
    }

    @Override
    public long getCapacity() {
        return this.getStorageDiskInfo().mapToLong(StorageInfo::capacity).sum();
    }

    @Override
    public long getStored() {
        return this.getStorageDiskInfo().mapToLong(StorageInfo::stored).sum();
    }

    private Stream<ItemStack> getDiskStacks() {
        return this.diskSlots.stream().map(Slot::getItem).filter(stack -> !stack.isEmpty());
    }

    private Stream<StorageInfo> getStorageDiskInfo() {
        return this.getDiskStacks().map(this.storageInfoAccessor::getInfo).flatMap(Optional::stream);
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }
}

