/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.api.network.security.SecurityActor;
import com.refinedmods.refinedstorage.api.network.security.SecurityPolicy;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardItem;
import com.refinedmods.refinedstorage.common.security.PlayerBoundSecurityCardData;
import com.refinedmods.refinedstorage.common.security.SecurityCardBoundPlayer;
import com.refinedmods.refinedstorage.common.security.SecurityCardExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SecurityCardItem
extends AbstractSecurityCardItem<PlayerBoundSecurityCardData> {
    private static final Component UNBOUND_HELP = IdentifierUtil.createTranslation("item", "security_card.unbound.help");
    private static final Component BOUND_HELP = IdentifierUtil.createTranslation("item", "security_card.bound.help");

    public SecurityCardItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        SecurityCardBoundPlayer boundPlayer = (SecurityCardBoundPlayer)stack.get(DataComponents.INSTANCE.getSecurityCardBoundPlayer());
        if (boundPlayer == null) {
            lines.add((Component)IdentifierUtil.createTranslation("item", "security_card.unbound").withStyle(ChatFormatting.GRAY));
        } else {
            lines.add((Component)IdentifierUtil.createTranslation("item", "security_card.bound", Component.literal((String)boundPlayer.playerName()).withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, lines, flag);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!stack.has(DataComponents.INSTANCE.getSecurityCardBoundPlayer())) {
                this.setBoundPlayer(serverPlayer, stack);
            }
        }
        return super.use(level, player, hand);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(this.isValid(stack) ? BOUND_HELP : UNBOUND_HELP));
    }

    @Override
    AbstractSecurityCardExtendedMenuProvider<PlayerBoundSecurityCardData> createMenuProvider(MinecraftServer server, SlotReference slotReference, SecurityPolicy policy, Set<PlatformPermission> dirtyPermissions, ItemStack stack) {
        return new SecurityCardExtendedMenuProvider((Component)stack.get(net.minecraft.core.component.DataComponents.CUSTOM_NAME), server, slotReference, policy, dirtyPermissions, Objects.requireNonNull((SecurityCardBoundPlayer)stack.get(DataComponents.INSTANCE.getSecurityCardBoundPlayer())));
    }

    @Override
    public boolean isValid(ItemStack stack) {
        return stack.has(DataComponents.INSTANCE.getSecurityCardBoundPlayer());
    }

    @Override
    public Optional<SecurityActor> getActor(ItemStack stack) {
        return Optional.ofNullable((SecurityCardBoundPlayer)stack.get(DataComponents.INSTANCE.getSecurityCardBoundPlayer())).map(SecurityCardBoundPlayer::toSecurityActor);
    }

    @Override
    public long getEnergyUsage() {
        return Platform.INSTANCE.getConfig().getSecurityCard().getEnergyUsage();
    }

    void setBoundPlayer(ServerPlayer player, ItemStack stack) {
        SecurityCardBoundPlayer boundPlayer = SecurityCardBoundPlayer.of(player);
        stack.set(DataComponents.INSTANCE.getSecurityCardBoundPlayer(), (Object)boundPlayer);
    }
}

