/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.importer;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.Items;
import java.util.function.ToLongFunction;

public class ImporterTransferQuotaProvider
implements ToLongFunction<ResourceKey> {
    private final long baseTransferQuota;
    private final UpgradeState upgradeState;
    private final boolean regulating;
    private final ToLongFunction<ResourceKey> currentAmountProvider;

    public ImporterTransferQuotaProvider(long singleAmount, UpgradeState upgradeState, ToLongFunction<ResourceKey> currentAmountProvider) {
        this.baseTransferQuota = upgradeState.has(Items.INSTANCE.getStackUpgrade()) ? singleAmount * 64L : singleAmount;
        this.upgradeState = upgradeState;
        this.regulating = upgradeState.has(Items.INSTANCE.getRegulatorUpgrade());
        this.currentAmountProvider = currentAmountProvider;
    }

    @Override
    public long applyAsLong(ResourceKey resource) {
        if (!this.regulating) {
            return this.baseTransferQuota;
        }
        long desiredAmount = this.upgradeState.getRegulatedAmount(resource);
        if (desiredAmount <= 0L) {
            return this.baseTransferQuota;
        }
        long currentAmount = this.currentAmountProvider.applyAsLong(resource);
        long stillAvailableToImport = currentAmount - desiredAmount;
        if (stillAvailableToImport <= 0L) {
            return 0L;
        }
        return Math.min(this.baseTransferQuota, stillAvailableToImport);
    }
}

