/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.controller;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.EnergyStorageImpl;
import com.refinedmods.refinedstorage.api.network.impl.node.controller.ControllerNetworkNode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.energy.TransferableBlockEntityEnergy;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.controller.AbstractControllerBlock;
import com.refinedmods.refinedstorage.common.controller.ControllerContainerMenu;
import com.refinedmods.refinedstorage.common.controller.ControllerData;
import com.refinedmods.refinedstorage.common.controller.ControllerEnergyType;
import com.refinedmods.refinedstorage.common.controller.ControllerType;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.energy.BlockEntityEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.CreativeEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.ItemBlockEnergyStorage;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<ControllerNetworkNode>
implements NetworkNodeExtendedMenuProvider<ControllerData>,
TransferableBlockEntityEnergy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerBlockEntity.class);
    private static final String TAG_CAPACITY = "capacity";
    private final ControllerType type;
    private final EnergyStorage energyStorage;
    private final RateLimiter energyStateChangeRateLimiter = RateLimiter.create((double)1.0);

    public ControllerBlockEntity(ControllerType type, BlockPos pos, BlockState state) {
        super(ControllerBlockEntity.getBlockEntityType(type), pos, state, new ControllerNetworkNode());
        this.type = type;
        this.energyStorage = ControllerBlockEntity.createEnergyStorage(type, this);
        ((ControllerNetworkNode)this.mainNetworkNode).setEnergyStorage(this.energyStorage);
    }

    private static EnergyStorage createEnergyStorage(ControllerType type, BlockEntity blockEntity) {
        if (type == ControllerType.CREATIVE) {
            return CreativeEnergyStorage.INSTANCE;
        }
        return new BlockEntityEnergyStorage(new EnergyStorageImpl(Platform.INSTANCE.getConfig().getController().getEnergyCapacity()), blockEntity);
    }

    private static BlockEntityType<ControllerBlockEntity> getBlockEntityType(ControllerType type) {
        return type == ControllerType.CREATIVE ? BlockEntities.INSTANCE.getCreativeController() : BlockEntities.INSTANCE.getController();
    }

    public void updateEnergyTypeInLevel(BlockState state) {
        ControllerEnergyType currentEnergyType = (ControllerEnergyType)((Object)state.getValue(AbstractControllerBlock.ENERGY_TYPE));
        ControllerEnergyType newEnergyType = ControllerEnergyType.ofState(((ControllerNetworkNode)this.mainNetworkNode).getState());
        if (newEnergyType != currentEnergyType && this.level != null && this.energyStateChangeRateLimiter.tryAcquire()) {
            LOGGER.debug("Energy type state change for controller at {}: {} -> {}", new Object[]{this.getBlockPos(), currentEnergyType, newEnergyType});
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue(AbstractControllerBlock.ENERGY_TYPE, (Comparable)((Object)newEnergyType)));
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ItemBlockEnergyStorage.writeToTag(tag, ((ControllerNetworkNode)this.mainNetworkNode).getActualStored());
        this.saveRenderingInfo(tag);
    }

    private void saveRenderingInfo(CompoundTag tag) {
        tag.putLong(TAG_CAPACITY, ((ControllerNetworkNode)this.mainNetworkNode).getActualCapacity());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        ItemBlockEnergyStorage.readFromTag(this.energyStorage, tag);
    }

    public Component getName() {
        MutableComponent defaultName = this.type == ControllerType.CREATIVE ? ContentNames.CREATIVE_CONTROLLER : ContentNames.CONTROLLER;
        return this.overrideName((Component)defaultName);
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new ControllerContainerMenu(syncId, inv, this, player);
    }

    @Override
    public ControllerData getMenuData() {
        return new ControllerData(this.getActualStored(), this.getActualCapacity());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, ControllerData> getMenuCodec() {
        return ControllerData.STREAM_CODEC;
    }

    long getActualStored() {
        return ((ControllerNetworkNode)this.mainNetworkNode).getActualStored();
    }

    long getActualCapacity() {
        return ((ControllerNetworkNode)this.mainNetworkNode).getActualCapacity();
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }
}

