/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.constructordestructor.AbstractItemConstructorStrategy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

class ItemDropConstructorStrategy
extends AbstractItemConstructorStrategy {
    private final long amount;

    ItemDropConstructorStrategy(ServerLevel level, BlockPos pos, Direction direction, boolean stackUpgrade) {
        super(level, pos, direction);
        this.amount = stackUpgrade ? 64L : 1L;
    }

    @Override
    protected long getTransferAmount() {
        return this.amount;
    }

    @Override
    protected boolean apply(ItemStack itemStack, Actor actor, Player actingPlayer) {
        Vec3 position = new Vec3(this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ());
        DefaultDispenseItemBehavior.spawnItem((Level)this.level, (ItemStack)itemStack, (int)6, (Direction)this.direction, (Position)position);
        return true;
    }

    @Override
    protected boolean hasWork() {
        return true;
    }
}

