/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.resource.repository;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.ResourceList;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

class ViewList<T> {
    private final List<T> list = new ArrayList<T>();
    private final List<T> listView = Collections.unmodifiableList(this.list);
    private final Map<ResourceKey, T> index = new HashMap<ResourceKey, T>();

    ViewList() {
    }

    @Nullable
    T get(ResourceKey resource) {
        return this.index.get(resource);
    }

    void remove(ResourceKey resource, T mapped) {
        this.list.remove(mapped);
        this.index.remove(resource);
    }

    void add(ResourceKey resource, T mapped, Comparator<T> sort) {
        this.index.put(resource, mapped);
        this.add(mapped, sort);
    }

    private void add(T mapped, Comparator<T> sort) {
        int wouldBePosition = Collections.binarySearch(this.list, mapped, sort);
        if (wouldBePosition < 0) {
            this.list.add(-wouldBePosition - 1, mapped);
        } else {
            this.list.add(wouldBePosition + 1, mapped);
        }
    }

    void update(T mapped, Comparator<T> sort) {
        this.list.remove(mapped);
        this.add(mapped, sort);
    }

    List<T> getListView() {
        return this.listView;
    }

    void clear() {
        this.index.clear();
        this.list.clear();
    }

    static <T> ViewList<T> createSorted(ResourceList source, Set<ResourceKey> stickyResources, Comparator<T> sort, ResourceRepositoryMapper<T> mapper, Predicate<T> filter) {
        ViewList<T> list = new ViewList<T>();
        for (ResourceKey resource : source.getAll()) {
            ViewList.tryAdd(resource, list, mapper, filter);
        }
        for (ResourceKey stickyResource : stickyResources) {
            if (list.index.containsKey(stickyResource)) continue;
            ViewList.tryAdd(stickyResource, list, mapper, filter);
        }
        list.list.sort(sort);
        return list;
    }

    private static <T> void tryAdd(ResourceKey resource, ViewList<T> list, ResourceRepositoryMapper<T> mapper, Predicate<T> filter) {
        Object mapped = mapper.apply(resource);
        ViewList.tryAdd(mapped, list, resource, filter);
    }

    private static <T> void tryAdd(T mapped, ViewList<T> newList, ResourceKey resource, Predicate<T> filter) {
        if (filter.test(mapped)) {
            newList.list.add(mapped);
            newList.index.put(resource, mapped);
        }
    }
}

