/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.task;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusBuilder;
import com.refinedmods.refinedstorage.api.autocrafting.task.AbstractTaskPattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkProvider;
import com.refinedmods.refinedstorage.api.autocrafting.task.PatternStepResult;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskListener;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskPlan;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.resource.list.ResourceList;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalTaskPattern
extends AbstractTaskPattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalTaskPattern.class);
    private final MutableResourceList expectedOutputs;
    private final ResourceList simulatedIterationInputs;
    private final long originalIterationsToSendToSink;
    private long iterationsToSendToSink;
    private long iterationsReceived;
    private boolean interceptedAnythingSinceLastStep;
    private boolean interceptedAnIterationAtLeastOnceSinceLastStep;
    @Nullable
    private ExternalPatternSink.Result lastSinkResult;
    @Nullable
    private ExternalPatternSinkKey lastSinkResultKey;
    private int currentSinkIndex;

    ExternalTaskPattern(Pattern pattern, TaskPlan.PatternPlan plan) {
        super(pattern, plan);
        this.originalIterationsToSendToSink = plan.iterations();
        this.expectedOutputs = MutableResourceListImpl.create();
        pattern.layout().outputs().forEach(output -> this.expectedOutputs.add(output.resource(), output.amount() * plan.iterations()));
        this.iterationsToSendToSink = plan.iterations();
        this.simulatedIterationInputs = this.calculateIterationInputs(Action.SIMULATE);
    }

    ExternalTaskPattern(TaskSnapshot.PatternSnapshot snapshot) {
        super(snapshot.pattern(), new TaskPlan.PatternPlan(snapshot.root(), Objects.requireNonNull(snapshot.externalPattern()).originalIterationsToSendToSink(), snapshot.ingredients()));
        this.expectedOutputs = snapshot.externalPattern().copyExpectedOutputs();
        this.simulatedIterationInputs = snapshot.externalPattern().simulatedIterationInputs();
        this.originalIterationsToSendToSink = snapshot.externalPattern().originalIterationsToSendToSink();
        this.iterationsToSendToSink = snapshot.externalPattern().iterationsToSendToSink();
        this.iterationsReceived = snapshot.externalPattern().iterationsReceived();
        this.interceptedAnythingSinceLastStep = snapshot.externalPattern().interceptedAnythingSinceLastStep();
        this.lastSinkResult = snapshot.externalPattern().lastSinkResult();
        this.lastSinkResultKey = snapshot.externalPattern().lastSinkResultKey();
    }

    @Override
    PatternStepResult step(MutableResourceList internalStorage, RootStorage rootStorage, ExternalPatternSinkProvider sinkProvider, TaskListener listener) {
        if (this.interceptedAnIterationAtLeastOnceSinceLastStep) {
            this.interceptedAnIterationAtLeastOnceSinceLastStep = false;
            listener.receivedExternalIteration(this.pattern);
        }
        if (this.expectedOutputs.isEmpty()) {
            return PatternStepResult.COMPLETED;
        }
        if (this.iterationsToSendToSink == 0L) {
            return this.idleOrRunning();
        }
        if (!this.acceptsIterationInputs(internalStorage, sinkProvider)) {
            return this.idleOrRunning();
        }
        LOGGER.debug("Stepped {} with {} iterations remaining", (Object)this.pattern, (Object)this.iterationsToSendToSink);
        --this.iterationsToSendToSink;
        this.interceptedAnythingSinceLastStep = false;
        return PatternStepResult.RUNNING;
    }

    private PatternStepResult idleOrRunning() {
        if (this.interceptedAnythingSinceLastStep) {
            this.interceptedAnythingSinceLastStep = false;
            return PatternStepResult.RUNNING;
        }
        return PatternStepResult.IDLE;
    }

    @Override
    long beforeInsert(ResourceKey resource, long amount) {
        if (this.root) {
            return 0L;
        }
        return this.trySatisfy(resource, amount);
    }

    @Override
    long afterInsert(ResourceKey resource, long amount) {
        if (!this.root) {
            return 0L;
        }
        return this.trySatisfy(resource, amount);
    }

    private long trySatisfy(ResourceKey resource, long amount) {
        long needed = this.expectedOutputs.get(resource);
        if (needed == 0L) {
            return 0L;
        }
        long correctedAmount = Math.min(needed, amount);
        this.expectedOutputs.remove(resource, correctedAmount);
        boolean receivedAtLeastOneIteration = this.updateIterationsReceived();
        if (receivedAtLeastOneIteration) {
            this.interceptedAnIterationAtLeastOnceSinceLastStep = true;
        }
        this.interceptedAnythingSinceLastStep = true;
        return correctedAmount;
    }

    private boolean updateIterationsReceived() {
        long originalIterationsReceived = this.iterationsReceived;
        long result = this.originalIterationsToSendToSink;
        for (ResourceAmount output : this.pattern.layout().outputs()) {
            long stillNeeded;
            long expected = output.amount() * this.originalIterationsToSendToSink;
            long receivedOutputs = expected - (stillNeeded = this.expectedOutputs.get(output.resource()));
            long receivedOutputIterations = receivedOutputs / output.amount();
            if (result <= receivedOutputIterations) continue;
            result = receivedOutputIterations;
        }
        this.iterationsReceived = result;
        return this.iterationsReceived > originalIterationsReceived;
    }

    @Override
    void appendStatus(TaskStatusBuilder builder) {
        long iterationsSentToSink;
        long iterationsProcessing;
        List<ResourceAmount> outputs = this.pattern.layout().outputs();
        if (this.iterationsToSendToSink > 0L) {
            for (ResourceAmount output : outputs) {
                builder.scheduled(output.resource(), output.amount() * this.iterationsToSendToSink);
            }
        }
        if ((iterationsProcessing = (iterationsSentToSink = this.originalIterationsToSendToSink - this.iterationsToSendToSink) - this.iterationsReceived) > 0L) {
            for (ResourceKey input : this.simulatedIterationInputs.getAll()) {
                builder.processing(input, this.simulatedIterationInputs.get(input) * iterationsProcessing, this.lastSinkResultKey);
            }
        }
        if (this.lastSinkResult != null) {
            switch (this.lastSinkResult) {
                case REJECTED: {
                    outputs.stream().map(ResourceAmount::resource).forEach(builder::rejected);
                    break;
                }
                case SKIPPED: {
                    outputs.stream().map(ResourceAmount::resource).forEach(builder::noneFound);
                    break;
                }
                case LOCKED: {
                    outputs.stream().map(ResourceAmount::resource).forEach(builder::locked);
                    break;
                }
            }
        }
    }

    @Override
    long getWeight() {
        return this.iterationsToSendToSink;
    }

    @Override
    double getPercentageCompleted() {
        return (double)this.iterationsReceived / (double)this.originalIterationsToSendToSink;
    }

    private boolean acceptsIterationInputs(MutableResourceList internalStorage, ExternalPatternSinkProvider sinkProvider) {
        ResourceList iterationInputsSimulated = this.calculateIterationInputs(Action.SIMULATE);
        if (!this.extractAll(iterationInputsSimulated, internalStorage, Action.SIMULATE)) {
            return false;
        }
        List<ExternalPatternSink> sinks = sinkProvider.getSinksByPatternLayout(this.pattern.layout());
        if (sinks.isEmpty()) {
            this.lastSinkResult = ExternalPatternSink.Result.SKIPPED;
            return false;
        }
        ExternalPatternSink sink = this.getSinkThatIsAcceptingResources(sinks, iterationInputsSimulated);
        if (sink == null) {
            return false;
        }
        ResourceList iterationInputs = this.calculateIterationInputs(Action.EXECUTE);
        this.extractAll(iterationInputs, internalStorage, Action.EXECUTE);
        if (sink.accept(this.pattern, iterationInputs.copyState(), Action.EXECUTE) != ExternalPatternSink.Result.ACCEPTED) {
            LOGGER.warn("Sink {} did not accept all inputs for pattern {}", (Object)sink, (Object)this.pattern);
        }
        return true;
    }

    @Nullable
    private ExternalPatternSink getSinkThatIsAcceptingResources(List<ExternalPatternSink> sinks, ResourceList iterationInputsSimulated) {
        if (this.currentSinkIndex >= sinks.size()) {
            this.currentSinkIndex = 0;
        }
        while (this.currentSinkIndex < sinks.size()) {
            ExternalPatternSink.Result simulatedResult;
            ExternalPatternSink sink = sinks.get(this.currentSinkIndex);
            this.lastSinkResult = simulatedResult = sink.accept(this.pattern, iterationInputsSimulated.copyState(), Action.SIMULATE);
            this.lastSinkResultKey = sink.getKey();
            ++this.currentSinkIndex;
            if (simulatedResult != ExternalPatternSink.Result.ACCEPTED) continue;
            return sink;
        }
        return null;
    }

    @Override
    TaskSnapshot.PatternSnapshot createSnapshot() {
        return new TaskSnapshot.PatternSnapshot(this.root, this.pattern, this.ingredients, null, new TaskSnapshot.ExternalPatternSnapshot(this.expectedOutputs.copy(), this.simulatedIterationInputs, this.originalIterationsToSendToSink, this.iterationsToSendToSink, this.iterationsReceived, this.interceptedAnythingSinceLastStep, this.lastSinkResult, this.lastSinkResultKey));
    }
}

