/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.task;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusBuilder;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkProvider;
import com.refinedmods.refinedstorage.api.autocrafting.task.PatternStepResult;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskListener;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskPlan;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.resource.list.ResourceList;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTaskPattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTaskPattern.class);
    protected final boolean root;
    protected final Pattern pattern;
    protected final Map<Integer, Map<ResourceKey, Long>> ingredients = new LinkedHashMap<Integer, Map<ResourceKey, Long>>();

    protected AbstractTaskPattern(Pattern pattern, TaskPlan.PatternPlan plan) {
        this.pattern = pattern;
        this.root = plan.root();
        for (Map.Entry<Integer, Map<ResourceKey, Long>> entry : plan.ingredients().entrySet()) {
            LinkedHashMap<ResourceKey, Long> possibilitiesCopy = new LinkedHashMap<ResourceKey, Long>(entry.getValue());
            this.ingredients.put(entry.getKey(), possibilitiesCopy);
        }
    }

    abstract PatternStepResult step(MutableResourceList var1, RootStorage var2, ExternalPatternSinkProvider var3, TaskListener var4);

    abstract TaskSnapshot.PatternSnapshot createSnapshot();

    abstract void appendStatus(TaskStatusBuilder var1);

    abstract long getWeight();

    abstract double getPercentageCompleted();

    protected final boolean extractAll(ResourceList inputs, MutableResourceList internalStorage, Action action) {
        for (ResourceKey inputResource : inputs.getAll()) {
            long inputAmount = inputs.get(inputResource);
            long inInternalStorage = internalStorage.get(inputResource);
            if (inInternalStorage < inputAmount) {
                return false;
            }
            if (action != Action.EXECUTE) continue;
            internalStorage.remove(inputResource, inputAmount);
            LOGGER.debug("Extracted {}x {} from internal storage", (Object)inputAmount, (Object)inputResource);
        }
        return true;
    }

    protected final ResourceList calculateIterationInputs(Action action) {
        MutableResourceListImpl iterationInputs = MutableResourceListImpl.orderPreserving();
        for (Map.Entry<Integer, Map<ResourceKey, Long>> ingredient : this.ingredients.entrySet()) {
            int ingredientIndex;
            if (this.calculateIterationInputs(ingredient, ingredientIndex = ingredient.getKey().intValue(), iterationInputs, action)) continue;
            throw new IllegalStateException();
        }
        return iterationInputs;
    }

    private boolean calculateIterationInputs(Map.Entry<Integer, Map<ResourceKey, Long>> ingredient, int ingredientIndex, MutableResourceList iterationInputs, Action action) {
        long needed = this.pattern.layout().ingredients().get(ingredientIndex).amount();
        for (Map.Entry<ResourceKey, Long> possibility : ingredient.getValue().entrySet()) {
            long available = Math.min(needed, possibility.getValue());
            if (available == 0L) continue;
            iterationInputs.add(possibility.getKey(), available);
            if (action == Action.EXECUTE) {
                possibility.setValue(possibility.getValue() - available);
            }
            if ((needed -= available) != 0L) continue;
            break;
        }
        return needed == 0L;
    }

    long beforeInsert(ResourceKey resource, long amount) {
        return 0L;
    }

    long afterInsert(ResourceKey resource, long amount) {
        return 0L;
    }
}

