/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.fakelevel;

import com.ldtteam.common.fakelevel.FakeLevel;
import com.ldtteam.common.fakelevel.IFakeLevelBlockGetter;
import com.ldtteam.common.fakelevel.IFakeLevelLightProvider;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SingleBlockFakeLevel
extends FakeLevel<SingleBlockFakeLevelGetter> {
    public SingleBlockFakeLevel(Level realLevel) {
        super(new SingleBlockFakeLevelGetter(), IFakeLevelLightProvider.USE_CLIENT_LEVEL, realLevel, null, true);
    }

    public void prepare(BlockState blockState, @Nullable BlockEntity blockEntity, Level realLevel) {
        ((SingleBlockFakeLevelGetter)this.getLevelSource()).blockEntity = blockEntity;
        ((SingleBlockFakeLevelGetter)this.getLevelSource()).blockState = blockState;
        this.setRealLevel(realLevel);
        if (blockEntity != null) {
            blockEntity.setLevel((Level)this);
        }
    }

    public void unset(@Nullable BlockEntity blockEntity) {
        ((SingleBlockFakeLevelGetter)this.getLevelSource()).blockEntity = null;
        ((SingleBlockFakeLevelGetter)this.getLevelSource()).blockState = null;
        this.setRealLevel(null);
        if (blockEntity != null) {
            try {
                blockEntity.setLevel(null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void withFakeLevelContext(BlockState blockState, @Nullable BlockEntity blockEntity, Level realLevel, Consumer<Level> action) {
        this.prepare(blockState, blockEntity, realLevel);
        action.accept(this);
        this.unset(blockEntity);
    }

    public <T> T useFakeLevelContext(BlockState blockState, @Nullable BlockEntity blockEntity, Level realLevel, Function<Level, T> action) {
        this.prepare(blockState, blockEntity, realLevel);
        T result = action.apply(this);
        this.unset(blockEntity);
        return result;
    }

    public static class SingleBlockFakeLevelGetter
    implements IFakeLevelBlockGetter {
        public BlockState blockState = null;
        public BlockEntity blockEntity = null;

        public BlockEntity getBlockEntity(BlockPos pos) {
            return this.blockEntity;
        }

        public BlockState getBlockState(BlockPos pos) {
            return this.blockState;
        }

        public int getHeight() {
            return 1;
        }

        @Override
        public int getSizeX() {
            return 1;
        }

        @Override
        public int getSizeZ() {
            return 1;
        }

        @Override
        public void describeSelfInCrashReport(CrashReportCategory category) {
            category.setDetail("Single block", () -> ((BlockState)this.blockState).toString());
            category.setDetail("Single block entity type", () -> this.blockEntity == null ? null : BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)this.blockEntity.getType()).toString());
        }
    }

    public static class SidedSingleBlockFakeLevel {
        private SingleBlockFakeLevel client;
        private SingleBlockFakeLevel server;

        public SingleBlockFakeLevel get(Level realLevel) {
            if (realLevel.isClientSide()) {
                return this.client != null ? this.client : (this.client = new SingleBlockFakeLevel(realLevel));
            }
            return this.server != null ? this.server : (this.server = new SingleBlockFakeLevel(realLevel));
        }
    }
}

