/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.fakelevel;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.phys.AABB;

public class FakeLevelEntityGetterAdapter
extends LevelEntityGetterAdapter<Entity> {
    public static final FakeLevelEntityGetterAdapter EMPTY = FakeLevelEntityGetterAdapter.ofEntities(Collections.emptyList());
    protected static final EntityTypeTest<Entity, Entity> ALWAYS_PASS_TEST = EntityTypeTest.forClass(Entity.class);

    protected FakeLevelEntityGetterAdapter(EntityLookup<Entity> entityLookup) {
        super(entityLookup, null);
    }

    public static <T extends Entity> FakeLevelEntityGetterAdapter ofEntities(Collection<T> entities) {
        EntityLookup entityLookup = new EntityLookup();
        entities.forEach(arg_0 -> ((EntityLookup)entityLookup).add(arg_0));
        return new FakeLevelEntityGetterAdapter((EntityLookup<Entity>)entityLookup);
    }

    public void get(AABB aabb, Consumer<Entity> sink) {
        this.get(ALWAYS_PASS_TEST, aabb, AbortableIterationConsumer.forConsumer(sink));
    }

    public <U extends Entity> void get(EntityTypeTest<Entity, U> predicate, AABB aabb, AbortableIterationConsumer<U> sink) {
        for (Entity e : this.getAll()) {
            Entity entity = (Entity)predicate.tryCast((Object)e);
            if (entity == null || !entity.getBoundingBox().intersects(aabb) || !sink.accept((Object)entity).shouldAbort()) continue;
            return;
        }
    }
}

