/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.UiRenderMacros;
import com.ldtteam.blockui.util.cursor.CursorUtils;
import com.ldtteam.blockui.views.BOWindow;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.Objects;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class BOScreen
extends Screen {
    protected double renderScale = 1.0;
    protected double mcScale = 1.0;
    protected BOWindow window;
    protected double x = 0.0;
    protected double y = 0.0;
    public static boolean isMouseLeftDown = false;
    protected boolean isOpen = false;
    protected int framebufferWidth;
    protected int framebufferHeight;
    protected int absoluteMouseX;
    protected int absoluteMouseY;

    public BOScreen(BOWindow w) {
        super((Component)Component.literal((String)"Blockout GUI"));
        this.window = w;
    }

    public void render(GuiGraphics ms, int mx, int my, float f) {
        if (this.minecraft == null || !this.isOpen) {
            return;
        }
        this.absoluteMouseX = mx;
        this.absoluteMouseY = my;
        this.framebufferWidth = ms.minecraft.getWindow().getWidth();
        this.framebufferHeight = ms.minecraft.getWindow().getHeight();
        int guiWidth = Math.max(this.framebufferWidth, 320);
        int guiHeight = Math.max(this.framebufferHeight, 240);
        boolean oldFilteringValue = NeoForgeRenderTypes.enableTextTextureLinearFiltering;
        NeoForgeRenderTypes.enableTextTextureLinearFiltering = false;
        this.mcScale = ms.minecraft.getWindow().getGuiScale();
        this.renderScale = this.window.getRenderType().calcRenderScale(ms.minecraft.getWindow(), this.window);
        if (this.window.hasLightbox() && ms.minecraft.screen == this) {
            UiRenderMacros.fillGradient(ms.pose(), 0, 0, this.framebufferWidth, this.framebufferHeight, -1072689136, -804253680);
        }
        this.width = this.window.getWidth();
        this.height = this.window.getHeight();
        this.x = Math.floor(((double)guiWidth - (double)this.width * this.renderScale) / 2.0);
        this.y = Math.floor(((double)guiHeight - (double)this.height * this.renderScale) / 2.0);
        Matrix4fStack shaderPs = RenderSystem.getModelViewStack();
        Matrix4f oldProjection = RenderSystem.getProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)this.framebufferWidth, (float)this.framebufferHeight, 0.0f, 1000.0f, ClientHooks.getGuiFarPlane()), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        shaderPs.pushMatrix();
        shaderPs.identity();
        shaderPs.translate(0.0f, 0.0f, 10000.0f - ClientHooks.getGuiFarPlane());
        RenderSystem.applyModelViewMatrix();
        PoseStack newMs = new PoseStack();
        newMs.translate(this.x, this.y, (double)ms.pose().last().pose().m32());
        newMs.scale((float)this.renderScale, (float)this.renderScale, 1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        try {
            BOGuiGraphics target = new BOGuiGraphics(ms.minecraft, newMs, ms.bufferSource());
            this.window.draw(target, this.calcRelativeX(mx), this.calcRelativeY(my));
            if (ms.minecraft.screen == this) {
                int debugX = (int)(-this.x / this.renderScale) + 3;
                if (Pane.debugging) {
                    String string = "XML: %s Scaling: %s (vanilla: %.2f our: %.2f) ".formatted(this.window.getXmlResourceLocation(), this.window.getRenderType().name(), this.mcScale, this.renderScale);
                    float f2 = debugX;
                    Objects.requireNonNull(this.minecraft.font);
                    debugX = target.drawString(string, f2, -9, Color.getByName("white"));
                }
                target.applyCursor(debugX);
            }
            this.window.drawLast(target, this.calcRelativeX(mx), this.calcRelativeY(my));
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"Rendering BO screen");
            CrashReportCategory category = crashReport.addCategory("BO screen rendering details");
            category.setDetail("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.setDetail("Scaling mode (window render type)", () -> this.window.getRenderType().name());
            category.setDetail("Vanilla gui scale", () -> Double.toString(this.mcScale));
            category.setDetail("BO gui scale", () -> Double.toString(this.renderScale));
            throw new ReportedException(crashReport);
        }
        finally {
            shaderPs.popMatrix();
            RenderSystem.setProjectionMatrix((Matrix4f)oldProjection, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
            RenderSystem.applyModelViewMatrix();
            NeoForgeRenderTypes.enableTextTextureLinearFiltering = oldFilteringValue;
        }
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key >= 0 && key <= 348) {
            try {
                return this.window.onKeyTyped('\u0000', key);
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"KeyPressed event for BO screen");
                CrashReportCategory category = crashReport.addCategory("BO screen key event details");
                category.setDetail("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.setDetail("GLFW key value", () -> Integer.toString(key));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public boolean charTyped(char ch, int key) {
        try {
            return this.window.onKeyTyped(ch, key);
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"CharTyped event for BO screen");
            CrashReportCategory category = crashReport.addCategory("BO screen char event details");
            category.setDetail("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.setDetail("Char value", () -> Character.toString(ch));
            throw new ReportedException(crashReport);
        }
    }

    public boolean mouseClicked(double mxIn, double myIn, int keyCode) {
        double mx = this.calcRelativeX(mxIn);
        double my = this.calcRelativeY(myIn);
        try {
            if (keyCode == 0) {
                isMouseLeftDown = true;
                return this.window.click(mx, my);
            }
            if (keyCode == 1) {
                return this.window.rightClick(mx, my);
            }
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"MousePressed event for BO screen");
            CrashReportCategory category = crashReport.addCategory("BO screen mouse event details");
            category.setDetail("XML res loc", () -> Objects.toString(this.window.getXmlResourceLocation()));
            category.setDetail("GLFW mouse key value", () -> Integer.toString(keyCode));
            throw new ReportedException(crashReport);
        }
        return false;
    }

    public boolean mouseScrolled(double mx, double my, double scrollHorizontalDiff, double scrollVerticalDiff) {
        if (scrollVerticalDiff != 0.0) {
            try {
                return this.window.scrollInput(scrollHorizontalDiff * 10.0, scrollVerticalDiff * 10.0, this.calcRelativeX(mx), this.calcRelativeY(my));
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"MouseScroll event for BO screen");
                CrashReportCategory category = crashReport.addCategory("BO screen scroll event details");
                category.setDetail("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.setDetail("Scroll value", () -> Double.toString(scrollVerticalDiff));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public boolean mouseDragged(double xIn, double yIn, int speed, double deltaX, double deltaY) {
        try {
            return this.window.onMouseDrag(this.calcRelativeX(xIn), this.calcRelativeY(yIn), speed, deltaX, deltaY);
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"MouseDragged event for BO screen");
            CrashReportCategory category = crashReport.addCategory("BO screen mouse event details");
            category.setDetail("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            throw new ReportedException(crashReport);
        }
    }

    public boolean mouseReleased(double mxIn, double myIn, int keyCode) {
        if (keyCode == 0) {
            isMouseLeftDown = false;
            try {
                return this.window.onMouseReleased(this.calcRelativeX(mxIn), this.calcRelativeY(myIn));
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"MouseReleased event for BO screen");
                CrashReportCategory category = crashReport.addCategory("BO screen mouse event details");
                category.setDetail("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.setDetail("GLFW mouse key value", () -> Integer.toString(keyCode));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public BOWindow getWindow() {
        return this.window;
    }

    public void tick() {
        try {
            if (this.minecraft != null) {
                if (!this.isOpen) {
                    this.window.onOpened();
                    this.isOpen = true;
                } else {
                    LocalPlayer player;
                    this.window.onUpdate();
                    LocalPlayer localPlayer = player = this.minecraft == null ? null : this.minecraft.player;
                    if (player != null && (!player.isAlive() || player.dead)) {
                        player.closeContainer();
                    }
                }
            }
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"Ticking/Updating BO screen");
            CrashReportCategory category = crashReport.addCategory("BO screen update details");
            category.setDetail("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.setDetail("Is opened", () -> Boolean.toString(this.isOpen));
            throw new ReportedException(crashReport);
        }
    }

    public void removed() {
        try {
            this.window.onClosed();
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"Closing BO screen");
            CrashReportCategory category = crashReport.addCategory("BO screen closing details");
            category.setDetail("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.setDetail("Is opened", () -> Boolean.toString(this.isOpen));
            throw new ReportedException(crashReport);
        }
        finally {
            BOWindow.clearFocus();
            CursorUtils.resetCursor();
        }
    }

    public boolean isPauseScreen() {
        return this.window.doesWindowPauseGame();
    }

    private double calcRelativeX(double xIn) {
        return (xIn * this.mcScale - this.x) / this.renderScale;
    }

    private double calcRelativeY(double yIn) {
        return (yIn * this.mcScale - this.y) / this.renderScale;
    }

    public double getRenderScale() {
        return this.renderScale;
    }

    public double getVanillaGuiScale() {
        return this.mcScale;
    }

    public int getFramebufferWidth() {
        return this.framebufferWidth;
    }

    public int getFramebufferHeight() {
        return this.framebufferHeight;
    }

    public int getAbsoluteMouseX() {
        return this.absoluteMouseX;
    }

    public int getAbsoluteMouseY() {
        return this.absoluteMouseY;
    }
}

