/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import appeng.core.definitions.AEItems;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.me.wireless.WirelessConnect;
import com.glodblock.github.extendedae.common.me.wireless.WirelessNode;
import com.glodblock.github.extendedae.config.EAEConfig;
import com.glodblock.github.extendedae.util.CacheHolder;
import com.glodblock.github.extendedae.xmod.jade.JadeDataProvider;
import com.glodblock.github.glodium.util.GlodUtil;
import gripe._90.megacells.definition.MEGAItems;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileWirelessConnector
extends AENetworkedBlockEntity
implements ServerTickingBlockEntity,
IUpgradeableObject,
IColorableBlockEntity,
WirelessNode,
JadeDataProvider {
    private boolean updateStatus = true;
    private long freq = 0L;
    private final WirelessConnect connect;
    private double powerUse;
    private final IUpgradeInventory upgrades;
    private final CacheHolder<BlockPos> other = CacheHolder.empty();
    @NotNull
    private AEColor color = AEColor.TRANSPARENT;

    public TileWirelessConnector(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileWirelessConnector.class, TileWirelessConnector::new, (Block)EAESingletons.WIRELESS_CONNECTOR), pos, blockState);
        this.getMainNode().setExposedOnSides(EnumSet.allOf(Direction.class));
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
        this.powerUse = 1.0;
        this.getMainNode().setIdlePowerUsage(this.powerUse);
        this.connect = new WirelessConnect(this);
        this.upgrades = UpgradeInventories.forMachine((ItemLike)EAESingletons.WIRELESS_CONNECTOR, (int)4, this::updatePowerUsage);
    }

    public void serverTick() {
        if (this.updateStatus) {
            this.updateStatus = false;
            this.other.expired();
            this.connect.updateStatus();
            this.updatePowerUsage();
            this.markForUpdate();
            this.reactive();
        }
    }

    @Override
    public IGridNode getGridNode() {
        return this.getMainNode().getNode();
    }

    public void updatePowerUsage() {
        double disc = 1.0 - this.calculateDisc();
        if (this.connect.isConnected()) {
            double dis = Math.max(this.connect.getDistance(), Math.E);
            this.powerUse = Math.max(1.0, dis * Math.log(dis) * disc);
            this.powerUse *= EAEConfig.wirelessPowerMultiplier;
        } else {
            this.powerUse = EAEConfig.wirelessPowerMultiplier;
        }
        this.getMainNode().setIdlePowerUsage(this.powerUse);
    }

    private double calculateDisc() {
        double disc = 0.1 * (double)this.upgrades.getInstalledUpgrades((ItemLike)AEItems.ENERGY_CARD);
        if (GlodUtil.checkMod((String)"megacells")) {
            disc += 0.2 * (double)this.upgrades.getInstalledUpgrades((ItemLike)MEGAItems.GREATER_ENERGY_CARD);
        }
        return disc;
    }

    public double getPowerUse() {
        return this.powerUse;
    }

    @Nullable
    public BlockPos getOtherSide() {
        if (this.connect.isConnected()) {
            if (!this.other.isValid()) {
                this.other.update(this.connect.getOtherSide());
            }
            return this.other.get();
        }
        return null;
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.updateStatus = true;
    }

    public void reactive() {
        this.connect.active();
    }

    public void onChunkUnloaded() {
        this.disconnect();
        super.onChunkUnloaded();
    }

    public void onReady() {
        super.onReady();
        this.updateStatus = true;
    }

    public void setRemoved() {
        this.disconnect();
        super.setRemoved();
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.freq = data.getLong("freq");
        this.upgrades.readFromNBT(data, "upgrades", registries);
        this.color = data.contains("color") ? AEColor.valueOf((String)data.getString("color")) : AEColor.TRANSPARENT;
        this.getMainNode().setGridColor(this.color);
        WirelessConnect.G.markUsed(this.freq);
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        data.putLong("freq", this.freq);
        this.upgrades.writeToNBT(data, "upgrades", registries);
        data.putString("color", this.color.name());
        WirelessConnect.G.markUsed(this.freq);
    }

    public void setFrequency(long freq) {
        this.freq = freq;
        this.updateStatus = true;
        this.setChanged();
    }

    public long getNewFreq() {
        return WirelessConnect.G.genFreq();
    }

    public void disconnect() {
        this.connect.destroy();
    }

    public boolean isConnected() {
        return this.connect.isConnected();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.DENSE_SMART;
    }

    public void breakOnRemove() {
        this.connect.destroy();
    }

    @Override
    public long getFrequency() {
        return this.freq;
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack card : this.upgrades) {
            drops.add(card);
        }
    }

    public void clearContent() {
        super.clearContent();
        this.upgrades.clear();
    }

    @NotNull
    public AEColor getColor() {
        return this.color;
    }

    public boolean recolourBlock(Direction side, AEColor colour, Player who) {
        if (colour == this.color) {
            return false;
        }
        this.color = colour;
        this.saveChanges();
        this.markForUpdate();
        this.getMainNode().setGridColor(this.color);
        return true;
    }

    @Override
    public String jadeID() {
        return "wireless";
    }

    @Override
    public void collectJadeInfo(CompoundTag tag) {
        tag.putString("color", this.color.name());
        this.getMainNode().ifPresent((gird, node) -> tag.putInt("used", node.getUsedChannels()));
    }
}

