/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util;

import java.util.Locale;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.VectorUtil;

public record TermAndVector(BytesRef term, float[] vector) {
    public int size() {
        return this.vector.length;
    }

    public TermAndVector normalizeVector() {
        float[] vector = (float[])this.vector.clone();
        VectorUtil.l2normalize(vector);
        return new TermAndVector(this.term, vector);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.term.utf8ToString());
        builder.append(" [");
        if (this.vector.length > 0) {
            for (int i = 0; i < this.vector.length - 1; ++i) {
                builder.append(String.format(Locale.ROOT, "%.3f,", Float.valueOf(this.vector[i])));
            }
            builder.append(String.format(Locale.ROOT, "%.3f]", Float.valueOf(this.vector[this.vector.length - 1])));
        }
        return builder.toString();
    }
}

