/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queryparser.flexible.standard.processors;

import java.util.List;
import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.messages.QueryParserMessages;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.ars_nouveau.queryparser.flexible.messages.MessageImpl;
import org.apache.lucene.ars_nouveau.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.ars_nouveau.queryparser.flexible.standard.nodes.IntervalQueryNode;

public class IntervalQueryNodeProcessor
extends QueryNodeProcessorImpl {
    private Analyzer analyzer;

    @Override
    public QueryNode process(QueryNode queryTree) throws QueryNodeException {
        this.analyzer = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ANALYZER);
        return super.process(queryTree);
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof IntervalQueryNode) {
            IntervalQueryNode intervalQueryNode = (IntervalQueryNode)node;
            if (this.analyzer == null) {
                throw new QueryNodeException(new MessageImpl(QueryParserMessages.ANALYZER_REQUIRED, intervalQueryNode.toString()));
            }
            intervalQueryNode.setAnalyzer(this.analyzer);
        }
        return node;
    }

    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

