/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.facet.sortedset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.PrimitiveIterator;
import org.apache.lucene.ars_nouveau.facet.FacetResult;
import org.apache.lucene.ars_nouveau.facet.Facets;
import org.apache.lucene.ars_nouveau.facet.FacetsConfig;
import org.apache.lucene.ars_nouveau.facet.LabelAndValue;
import org.apache.lucene.ars_nouveau.facet.TopOrdAndIntQueue;
import org.apache.lucene.ars_nouveau.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.ars_nouveau.index.SortedSetDocValues;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.PriorityQueue;

abstract class AbstractSortedSetDocValueFacetCounts
extends Facets {
    final SortedSetDocValuesReaderState state;
    final FacetsConfig stateConfig;
    final SortedSetDocValues dv;
    final String field;

    AbstractSortedSetDocValueFacetCounts(SortedSetDocValuesReaderState state) throws IOException {
        this.state = state;
        this.field = state.getField();
        this.stateConfig = state.getFacetsConfig();
        this.dv = state.getDocValues();
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        AbstractSortedSetDocValueFacetCounts.validateTopN(topN);
        if (!this.hasCounts()) {
            return null;
        }
        TopChildrenForPath topChildrenForPath = this.getTopChildrenForPath(topN, dim, path);
        return this.createFacetResult(topChildrenForPath, dim, path);
    }

    @Override
    public FacetResult getAllChildren(String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.stateConfig.getDimConfig(dim);
        ChildIterationCursor iterationCursor = this.prepareChildIteration(dim, dimConfig, path);
        if (iterationCursor == null) {
            return null;
        }
        if (!this.hasCounts()) {
            return null;
        }
        int pathCount = 0;
        ArrayList<LabelAndValue> labelValues = new ArrayList<LabelAndValue>();
        while (iterationCursor.childIterator.hasNext()) {
            int ord = iterationCursor.childIterator.next();
            int count = this.getCount(ord);
            if (count <= 0) continue;
            pathCount += count;
            BytesRef term = this.dv.lookupOrd(ord);
            String[] parts = FacetsConfig.stringToPath(term.utf8ToString());
            labelValues.add(new LabelAndValue(parts[parts.length - 1], count));
        }
        pathCount = this.adjustPathCountIfNecessary(dimConfig, iterationCursor.pathOrd, pathCount);
        return new FacetResult(dim, path, pathCount, labelValues.toArray(new LabelAndValue[0]), labelValues.size());
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        if (!this.stateConfig.getDimConfig((String)dim).hierarchical && path.length != 1) {
            throw new IllegalArgumentException(dim + " is not configured as hierarchical, path must be length=1");
        }
        int ord = (int)this.dv.lookupTerm(new BytesRef(FacetsConfig.pathToString(dim, path)));
        if (ord < 0) {
            return -1;
        }
        return !this.hasCounts() ? 0 : this.getCount(ord);
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        AbstractSortedSetDocValueFacetCounts.validateTopN(topN);
        if (!this.hasCounts()) {
            return Collections.emptyList();
        }
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        for (String dim : this.state.getDims()) {
            TopChildrenForPath topChildrenForPath = this.getTopChildrenForPath(topN, dim, new String[0]);
            FacetResult facetResult = this.createFacetResult(topChildrenForPath, dim, new String[0]);
            if (facetResult == null) continue;
            results.add(facetResult);
        }
        results.sort((a, b) -> {
            if (a.value.intValue() > b.value.intValue()) {
                return -1;
            }
            if (b.value.intValue() > a.value.intValue()) {
                return 1;
            }
            return a.dim.compareTo(b.dim);
        });
        return results;
    }

    @Override
    public List<FacetResult> getTopDims(int topNDims, int topNChildren) throws IOException {
        AbstractSortedSetDocValueFacetCounts.validateTopN(topNDims);
        AbstractSortedSetDocValueFacetCounts.validateTopN(topNChildren);
        if (!this.hasCounts()) {
            return Collections.emptyList();
        }
        PriorityQueue<DimValue> pq = new PriorityQueue<DimValue>(this, topNDims){

            @Override
            protected boolean lessThan(DimValue a, DimValue b) {
                if (a.value > b.value) {
                    return false;
                }
                if (a.value < b.value) {
                    return true;
                }
                return a.dim.compareTo(b.dim) > 0;
            }
        };
        HashMap<String, TopChildrenForPath> intermediateResults = null;
        for (String dim : this.state.getDims()) {
            int dimCount;
            FacetsConfig.DimConfig dimConfig = this.stateConfig.getDimConfig(dim);
            if (dimConfig.hierarchical) {
                int dimOrd = this.state.getDimTree((String)dim).dimStartOrd;
                dimCount = this.getCount(dimOrd);
            } else {
                SortedSetDocValuesReaderState.OrdRange ordRange = this.state.getOrdRange(dim);
                int dimOrd = ordRange.start();
                if (dimConfig.multiValued) {
                    dimCount = dimConfig.requireDimCount ? this.getCount(dimOrd) : -1;
                } else {
                    PrimitiveIterator.OfInt childIt = ordRange.iterator();
                    TopChildrenForPath topChildrenForPath = this.computeTopChildren(childIt, topNChildren, dimConfig, dimOrd);
                    if (intermediateResults == null) {
                        intermediateResults = new HashMap<String, TopChildrenForPath>();
                    }
                    intermediateResults.put(dim, topChildrenForPath);
                    dimCount = topChildrenForPath.pathCount;
                }
            }
            if (dimCount == 0) continue;
            if (pq.size() < topNDims) {
                pq.add(new DimValue(dim, dimCount));
                continue;
            }
            if (dimCount <= ((DimValue)pq.top()).value && (dimCount != ((DimValue)pq.top()).value || dim.compareTo(((DimValue)pq.top()).dim) >= 0)) continue;
            DimValue bottomDim = (DimValue)pq.top();
            bottomDim.dim = dim;
            bottomDim.value = dimCount;
            pq.updateTop();
        }
        int resultSize = pq.size();
        FacetResult[] results = new FacetResult[resultSize];
        while (pq.size() > 0) {
            DimValue dimValue = (DimValue)pq.pop();
            assert (dimValue != null);
            TopChildrenForPath topChildrenForPath = null;
            if (intermediateResults != null) {
                topChildrenForPath = (TopChildrenForPath)intermediateResults.get(dimValue.dim);
            }
            if (topChildrenForPath == null) {
                topChildrenForPath = this.getTopChildrenForPath(topNChildren, dimValue.dim, new String[0]);
            }
            FacetResult facetResult = this.createFacetResult(topChildrenForPath, dimValue.dim, new String[0]);
            assert (facetResult != null);
            results[--resultSize] = facetResult;
        }
        return Arrays.asList(results);
    }

    abstract boolean hasCounts();

    abstract int getCount(int var1);

    private ChildIterationCursor prepareChildIteration(String dim, FacetsConfig.DimConfig dimConfig, String ... path) throws IOException {
        PrimitiveIterator.OfInt childIterator;
        int pathOrd;
        if (dimConfig.hierarchical) {
            SortedSetDocValuesReaderState.DimTree dimTree = this.state.getDimTree(dim);
            pathOrd = path.length > 0 ? (int)this.dv.lookupTerm(new BytesRef(FacetsConfig.pathToString(dim, path))) : dimTree.dimStartOrd;
            if (pathOrd < 0) {
                return null;
            }
            childIterator = dimTree.iterator(pathOrd);
        } else {
            if (path.length > 0) {
                throw new IllegalArgumentException("Field is not configured as hierarchical, path should be 0 length");
            }
            SortedSetDocValuesReaderState.OrdRange ordRange = this.state.getOrdRange(dim);
            if (ordRange == null) {
                return null;
            }
            pathOrd = ordRange.start();
            childIterator = ordRange.iterator();
            if (dimConfig.multiValued && dimConfig.requireDimCount) {
                childIterator.next();
            }
        }
        return new ChildIterationCursor(pathOrd, childIterator);
    }

    private TopChildrenForPath getTopChildrenForPath(int topN, String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.stateConfig.getDimConfig(dim);
        ChildIterationCursor iterationCursor = this.prepareChildIteration(dim, dimConfig, path);
        if (iterationCursor == null) {
            return null;
        }
        return this.computeTopChildren(iterationCursor.childIterator, topN, dimConfig, iterationCursor.pathOrd);
    }

    private TopChildrenForPath computeTopChildren(PrimitiveIterator.OfInt childOrds, int topN, FacetsConfig.DimConfig dimConfig, int pathOrd) {
        TopOrdAndIntQueue q = null;
        int pathCount = 0;
        int childCount = 0;
        TopOrdAndIntQueue.OrdAndInt reuse = null;
        while (childOrds.hasNext()) {
            int ord = childOrds.next();
            int count = this.getCount(ord);
            if (count <= 0) continue;
            pathCount += count;
            ++childCount;
            if (q == null) {
                q = new TopOrdAndIntQueue(topN);
            }
            if (reuse == null) {
                reuse = (TopOrdAndIntQueue.OrdAndInt)q.newOrdAndValue();
            }
            reuse.ord = ord;
            reuse.value = count;
            reuse = q.insertWithOverflow(reuse);
        }
        pathCount = this.adjustPathCountIfNecessary(dimConfig, pathOrd, pathCount);
        return new TopChildrenForPath(pathCount, childCount, q);
    }

    private int adjustPathCountIfNecessary(FacetsConfig.DimConfig dimConfig, int pathOrd, int computedCount) {
        if (dimConfig.hierarchical) {
            return this.getCount(pathOrd);
        }
        if (dimConfig.multiValued) {
            if (dimConfig.requireDimCount) {
                return this.getCount(pathOrd);
            }
            return -1;
        }
        return computedCount;
    }

    private FacetResult createFacetResult(TopChildrenForPath topChildrenForPath, String dim, String ... path) throws IOException {
        if (topChildrenForPath == null || topChildrenForPath.childCount == 0) {
            return null;
        }
        TopOrdAndIntQueue q = topChildrenForPath.q;
        assert (q != null);
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndIntQueue.OrdAndInt ordAndValue = (TopOrdAndIntQueue.OrdAndInt)q.pop();
            assert (ordAndValue != null);
            BytesRef term = this.dv.lookupOrd(ordAndValue.ord);
            String[] parts = FacetsConfig.stringToPath(term.utf8ToString());
            labelValues[i] = new LabelAndValue(parts[parts.length - 1], ordAndValue.value);
        }
        return new FacetResult(dim, path, topChildrenForPath.pathCount, labelValues, topChildrenForPath.childCount);
    }

    record TopChildrenForPath(int pathCount, int childCount, TopOrdAndIntQueue q) {
    }

    record ChildIterationCursor(int pathOrd, PrimitiveIterator.OfInt childIterator) {
    }

    static final class DimValue {
        String dim;
        int value;

        DimValue(String dim, int value) {
            this.dim = dim;
            this.value = value;
        }
    }
}

