/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.occultism.impl;

import com.klikli_dev.occultism.common.misc.ItemStackKey;
import com.klikli_dev.occultism.common.misc.MapItemStackHandler;
import com.klikli_dev.theurgy.content.behaviour.filter.Filter;
import com.klikli_dev.theurgy.content.behaviour.filter.ListFilter;
import com.klikli_dev.theurgy.integration.occultism.OccultismIntegration;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class OccultismIntegrationImpl
implements OccultismIntegration {
    @Override
    public boolean isLoaded() {
        return ModList.get().isLoaded("occultism");
    }

    @Override
    public boolean tryPerformStorageActuatorExtraction(Level level, IItemHandler extractCap, Filter extractFilter, IItemHandler insertCap, Filter insertFilter, int extractionAmount) {
        if (!this.isLoaded()) {
            return false;
        }
        return OccultismHelper.tryPerformStorageActuatorExtraction(level, extractCap, extractFilter, insertCap, insertFilter, extractionAmount);
    }

    public static class OccultismHelper {
        public static boolean tryPerformStorageActuatorExtraction(Level level, IItemHandler extractCap, Filter extractFilter, IItemHandler insertCap, Filter insertFilter, int extractionAmount) {
            MapItemStackHandler mapItemStackHandler;
            block5: {
                block4: {
                    if (!(extractCap instanceof MapItemStackHandler)) break block4;
                    mapItemStackHandler = (MapItemStackHandler)extractCap;
                    if (extractFilter instanceof ListFilter) break block5;
                }
                return false;
            }
            ListFilter listFilter = (ListFilter)extractFilter;
            if (listFilter.isDenyList()) {
                return false;
            }
            return OccultismHelper.performExtraction(level, mapItemStackHandler, listFilter, insertCap, insertFilter, extractionAmount);
        }

        protected static boolean performExtraction(Level level, MapItemStackHandler extractCap, ListFilter extractFilter, IItemHandler insertCap, Filter insertFilter, int extractionAmount) {
            List<ItemStack> filterItems = extractFilter.filterItems();
            for (ItemStack filterItem : filterItems) {
                ItemStack inserted;
                ItemStackKey key = ItemStackKey.of((ItemStack)filterItem);
                ItemStack extractStack = extractFilter.shouldRespectDataComponents() ? extractCap.extractItem(key, extractionAmount, true) : extractCap.extractItemIgnoreComponents(key.stack(), extractionAmount, true);
                if (extractStack.isEmpty() || !insertFilter.test(level, extractStack) || (inserted = ItemHandlerHelper.insertItemStacked((IItemHandler)insertCap, (ItemStack)extractStack, (boolean)true)).getCount() == extractStack.getCount()) continue;
                ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)insertCap, (ItemStack)extractStack, (boolean)false);
                extractCap.extractItem(extractFilter.shouldRespectDataComponents() ? key : ItemStackKey.of((ItemStack)extractStack), extractStack.getCount() - remaining.getCount(), false);
                return true;
            }
            return false;
        }
    }
}

