/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.jei.recipes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.klikli_dev.theurgy.content.gui.GuiTextures;
import com.klikli_dev.theurgy.content.recipe.AccumulationRecipe;
import com.klikli_dev.theurgy.integration.jei.JeiDrawables;
import com.klikli_dev.theurgy.integration.jei.JeiRecipeTypes;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import java.util.Arrays;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class AccumulationCategory
implements IRecipeCategory<RecipeHolder<AccumulationRecipe>> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedAnimatedArrow;

    public AccumulationCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(82, 40);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BlockRegistry.SAL_AMMONIAC_ACCUMULATOR.get()));
        this.localizedName = Component.translatable((String)"theurgy.jei.category.accumulation");
        this.cachedAnimatedArrow = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(this){

            @NotNull
            public IDrawableAnimated load(@NotNull Integer cookTime) {
                return JeiDrawables.asAnimatedDrawable(guiHelper, GuiTextures.JEI_ARROW_RIGHT_FULL, cookTime, IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip(int overrideAmount) {
        return (view, tooltip) -> {
            Optional displayed = view.getDisplayedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK);
            if (displayed.isEmpty()) {
                return;
            }
            FluidStack fluidStack = (FluidStack)displayed.get();
            int amount = overrideAmount == -1 ? fluidStack.getAmount() : overrideAmount;
            MutableComponent text = Component.translatable((String)"theurgy.misc.unit.millibuckets", (Object[])new Object[]{amount}).withStyle(ChatFormatting.GOLD);
            tooltip.add(text);
        };
    }

    protected IDrawableAnimated getAnimatedArrow(RecipeHolder<AccumulationRecipe> recipe) {
        int cookTime = ((AccumulationRecipe)recipe.value()).getTime();
        if (cookTime <= 0) {
            cookTime = 100;
        }
        return (IDrawableAnimated)this.cachedAnimatedArrow.getUnchecked((Object)cookTime);
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@NotNull RecipeHolder<AccumulationRecipe> recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GuiTextures.JEI_ARROW_RIGHT_EMPTY.render(guiGraphics, 24, 2);
        this.getAnimatedArrow(recipe).draw(guiGraphics, 24, 2);
        this.drawCookTime(recipe, guiGraphics, 29);
    }

    protected void drawCookTime(RecipeHolder<AccumulationRecipe> recipe, GuiGraphics guiGraphics, int y) {
        int cookTime = ((AccumulationRecipe)recipe.value()).getTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"theurgy.gui.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            int stringWidth = font.width((FormattedText)timeString);
            guiGraphics.drawString(font, (Component)timeString, this.background.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<AccumulationRecipe> recipe, @NotNull IFocusGroup focuses) {
        if (((AccumulationRecipe)recipe.value()).hasEvaporant()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setBackground(JeiDrawables.INPUT_SLOT, -1, -1).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.stream(((AccumulationRecipe)recipe.value()).getEvaporant().getFluids()).toList())).setFluidRenderer(1000L, false, 16, 16).addTooltipCallback(AccumulationCategory.addFluidTooltip(((AccumulationRecipe)recipe.value()).getEvaporantAmount()));
        }
        if (((AccumulationRecipe)recipe.value()).hasSolute()) {
            assert (((AccumulationRecipe)recipe.value()).getSolute() != null);
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 21).setBackground(JeiDrawables.INPUT_SLOT, -1, -1).addIngredients(((AccumulationRecipe)recipe.value()).getSolute());
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 56, 1).setBackground(JeiDrawables.INPUT_SLOT, -1, -1).addFluidStack(((AccumulationRecipe)recipe.value()).getResult().getFluid(), (long)((AccumulationRecipe)recipe.value()).getResult().getAmount())).addTooltipCallback(AccumulationCategory.addFluidTooltip(((AccumulationRecipe)recipe.value()).getResult().getAmount()));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(new ItemStack((ItemLike)((AccumulationRecipe)recipe.value()).getResult().getFluid().getBucket()));
    }

    @NotNull
    public RecipeType<RecipeHolder<AccumulationRecipe>> getRecipeType() {
        return JeiRecipeTypes.ACCUMULATION;
    }
}

