/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.gettingstarted.exaltation;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DigestionVatEntry
extends EntryProvider {
    public static final String ENTRY_ID = "digestion_vat";

    public DigestionVatEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Exaltation Apparatus");
        this.pageText("As discussed, Exaltation consists of Digestion and the already known Fermentation and Reformation.\n\\\n\\\nView the {0} Category on how to craft and use the required apparatus.\n", new Object[]{this.entryLink("Apparatus", "apparatus", "transmutation_and_exaltation")});
        this.page("reformation_array", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Reformation Array");
        this.pageText("Once again you need to set up a reformation array, the usage was already discussed in the {0} and following entries.\n", new Object[]{this.entryLink("Reformation Array", "getting_started", "reformation_array")});
        this.page("fermentation_vat", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.FERMENTATION_VAT.get()})).withText(this.context().pageText()));
        this.pageText("You also need at least one fermentation vat. Multiple vats can be used to process multiple sulfurs in parallel.\n");
        this.page(ENTRY_ID, () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.DIGESTION_VAT.get()})).withText(this.context().pageText()));
        this.pageText("Finally you also need at least one digestion vat. Multiple vats can be used to process multiple niters in parallel.\n");
    }

    protected String entryName() {
        return "Required Apparatus";
    }

    protected String entryDescription() {
        return "The apparatus needed for exaltation";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)ItemRegistry.DIGESTION_VAT.get()));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

