/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator;

import com.klikli_dev.theurgy.content.recipe.AccumulationRecipe;
import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerWithFluidRecipeInput;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

class SalAmmoniacAccumulatorCachedCheck
implements RecipeManager.CachedCheck<ItemHandlerWithFluidRecipeInput, AccumulationRecipe> {
    private final RecipeType<AccumulationRecipe> type;
    private final RecipeManager.CachedCheck<ItemHandlerWithFluidRecipeInput, AccumulationRecipe> internal;
    @Nullable
    private ResourceLocation lastRecipe;

    public SalAmmoniacAccumulatorCachedCheck(RecipeType<AccumulationRecipe> type) {
        this.type = type;
        this.internal = RecipeManager.createCheck(type);
    }

    private Optional<RecipeHolder<AccumulationRecipe>> getRecipeFor(ItemStack stack, Level level, @Nullable ResourceLocation lastRecipe) {
        RecipeHolder recipe;
        RecipeManager recipeManager = level.getRecipeManager();
        if (lastRecipe != null && (recipe = recipeManager.byKeyTyped(this.type, lastRecipe)) != null && ((AccumulationRecipe)recipe.value()).hasSolute() && ((AccumulationRecipe)recipe.value()).getSolute().test(stack)) {
            return Optional.of(recipe);
        }
        return recipeManager.byType(this.type).stream().filter(entry -> ((AccumulationRecipe)entry.value()).hasSolute() && ((AccumulationRecipe)entry.value()).getSolute().test(stack)).findFirst();
    }

    private Optional<RecipeHolder<AccumulationRecipe>> getRecipeFor(FluidStack stack, Level level, @Nullable ResourceLocation lastRecipe) {
        RecipeHolder recipe;
        RecipeManager recipeManager = level.getRecipeManager();
        if (lastRecipe != null && (recipe = recipeManager.byKeyTyped(this.type, lastRecipe)) != null && ((AccumulationRecipe)recipe.value()).hasEvaporant() && ((AccumulationRecipe)recipe.value()).getEvaporant().ingredient().test(stack)) {
            return Optional.of(recipe);
        }
        return recipeManager.byType(this.type).stream().filter(entry -> ((AccumulationRecipe)entry.value()).hasEvaporant() && ((AccumulationRecipe)entry.value()).getEvaporant().ingredient().test(stack)).findFirst();
    }

    public Optional<RecipeHolder<AccumulationRecipe>> getRecipeFor(ItemStack stack, Level level) {
        Optional<RecipeHolder<AccumulationRecipe>> optional = this.getRecipeFor(stack, level, this.lastRecipe);
        if (optional.isPresent()) {
            RecipeHolder<AccumulationRecipe> recipeHolder = optional.get();
            this.lastRecipe = recipeHolder.id();
            return optional;
        }
        return Optional.empty();
    }

    public Optional<RecipeHolder<AccumulationRecipe>> getRecipeFor(FluidStack stack, Level level) {
        Optional<RecipeHolder<AccumulationRecipe>> optional = this.getRecipeFor(stack, level, this.lastRecipe);
        if (optional.isPresent()) {
            RecipeHolder<AccumulationRecipe> recipeHolder = optional.get();
            this.lastRecipe = recipeHolder.id();
            return optional;
        }
        return Optional.empty();
    }

    public Optional<RecipeHolder<AccumulationRecipe>> getRecipeFor(ItemHandlerWithFluidRecipeInput container, Level level) {
        Optional recipe = this.internal.getRecipeFor((RecipeInput)container, level);
        if (recipe.isPresent()) {
            this.lastRecipe = ((RecipeHolder)recipe.get()).id();
        }
        return recipe;
    }
}

