/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.pyromanticbrazier;

import com.klikli_dev.theurgy.content.apparatus.pyromanticbrazier.PyromanticBrazierBlockEntity;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PyromanticBrazierBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public PyromanticBrazierBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.FALSE));
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof PyromanticBrazierBlockEntity) {
            boolean brazierHasNonFuel;
            PyromanticBrazierBlockEntity blockEntity2 = (PyromanticBrazierBlockEntity)blockEntity;
            ItemStack inputStack = blockEntity2.inventory.getStackInSlot(0);
            ItemStack stackInHand = pPlayer.getItemInHand(pHand);
            boolean bl = brazierHasNonFuel = !inputStack.isEmpty() && blockEntity2.getBurnDuration(inputStack) == 0;
            if (stackInHand.isEmpty() || brazierHasNonFuel) {
                if (!inputStack.isEmpty()) {
                    pPlayer.getInventory().placeItemBackInInventory(inputStack);
                    blockEntity2.inventory.setStackInSlot(0, ItemStack.EMPTY);
                    return ItemInteractionResult.SUCCESS;
                }
            } else {
                ItemStack remainder = blockEntity2.inventory.insertItem(0, stackInHand, false);
                pPlayer.setItemInHand(pHand, remainder);
                if (remainder.getCount() != stackInHand.getCount()) {
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)super.getStateForPlacement(pContext).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LIT});
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            if (pRandom.nextInt(10) == 0) {
                pLevel.playLocalSound((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + pRandom.nextFloat(), pRandom.nextFloat() * 0.7f + 0.6f, false);
            }
            if (pRandom.nextInt(5) == 0) {
                for (int i = 0; i < pRandom.nextInt(1) + 1; ++i) {
                    pLevel.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, (double)(pRandom.nextFloat() / 2.0f), 5.0E-5, (double)(pRandom.nextFloat() / 2.0f));
                }
            }
        }
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!pState.is(pNewState.getBlock()) && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof PyromanticBrazierBlockEntity) {
            PyromanticBrazierBlockEntity blockEntity2 = (PyromanticBrazierBlockEntity)blockEntity;
            for (int i = 0; i < blockEntity2.inventory.getSlots(); ++i) {
                Containers.dropItemStack((Level)pLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), (ItemStack)blockEntity2.inventory.getStackInSlot(i));
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return BlockEntityRegistry.PYROMANTIC_BRAZIER.get().create(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return (Boolean)pState.getValue((Property)LIT) != false ? (lvl, pos, blockState, t) -> {
                if (t instanceof PyromanticBrazierBlockEntity) {
                    PyromanticBrazierBlockEntity blockEntity = (PyromanticBrazierBlockEntity)t;
                    blockEntity.tickClient();
                }
            } : null;
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof PyromanticBrazierBlockEntity) {
                PyromanticBrazierBlockEntity blockEntity = (PyromanticBrazierBlockEntity)t;
                blockEntity.tickServer();
            }
        };
    }
}

