/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.Message;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class AddBookmarkMessage
implements Message {
    public static final CustomPacketPayload.Type<AddBookmarkMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"modonomicon", (String)"add_bookmark"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AddBookmarkMessage> STREAM_CODEC = StreamCodec.composite(BookAddress.STREAM_CODEC, m -> m.address, AddBookmarkMessage::new);
    public BookAddress address;

    public AddBookmarkMessage(BookAddress address) {
        this.address = address;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        Book book = BookDataManager.get().getBook(this.address.bookId());
        if (BookVisualStateManager.get().getBookmarksFor((Player)player, book).stream().noneMatch(e -> e.entryId().equals((Object)this.address.entryId()))) {
            BookVisualStateManager.get().addBookmarkFor((Player)player, book, this.address);
        }
        BookVisualStateManager.get().syncFor(player);
    }
}

