/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.platform.Services;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class BookModLoadedCondition
extends BookCondition {
    protected String modId;

    public BookModLoadedCondition(Component component, String modId) {
        super(component);
        this.modId = modId;
    }

    public static BookModLoadedCondition fromJson(ResourceLocation conditionParentId, JsonObject json, HolderLookup.Provider provider) {
        String modId = GsonHelper.getAsString((JsonObject)json, (String)"mod_id");
        MutableComponent tooltip = Component.translatable((String)"tooltip.modonomicon.condition.mod_loaded", (Object[])new Object[]{modId});
        if (json.has("tooltip")) {
            tooltip = BookModLoadedCondition.tooltipFromJson(json, provider);
        }
        return new BookModLoadedCondition((Component)tooltip, modId);
    }

    public static BookModLoadedCondition fromNetwork(RegistryFriendlyByteBuf buffer) {
        Component tooltip = buffer.readBoolean() ? (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer) : null;
        String modId = buffer.readUtf();
        return new BookModLoadedCondition(tooltip, modId);
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Condition.MOD_LOADED;
    }

    @Override
    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.tooltip);
        }
        buffer.writeUtf(this.modId);
    }

    @Override
    public boolean test(BookConditionContext context, Player player) {
        return Services.PLATFORM.isModLoaded(this.modId);
    }

    @Override
    public boolean testOnLoad() {
        return Services.PLATFORM.isModLoaded(this.modId);
    }
}

