/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BlockEntityBaseContainerWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.itemcollectors.CollectorBlockEntity;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseXRange;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseYRange;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseZRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseXRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseYRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseZRange;
import com.supermartijn642.itemcollectors.packet.PacketToggleDurability;
import com.supermartijn642.itemcollectors.packet.PacketToggleShowArea;
import com.supermartijn642.itemcollectors.packet.PacketToggleWhitelist;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorContainer;
import com.supermartijn642.itemcollectors.screen.ArrowButton;
import com.supermartijn642.itemcollectors.screen.DurabilityButton;
import com.supermartijn642.itemcollectors.screen.ShowAreaButton;
import com.supermartijn642.itemcollectors.screen.WhitelistButton;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedCollectorScreen
extends BlockEntityBaseContainerWidget<CollectorBlockEntity, AdvancedCollectorContainer> {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"itemcollectors", (String)"textures/filter_screen.png");
    private WhitelistButton whitelistButton;
    private DurabilityButton durabilityButton;
    private ShowAreaButton showAreaButton;

    public AdvancedCollectorScreen(Level level, BlockPos pos) {
        super(0, 0, 224, 206, level, pos);
    }

    protected Component getNarrationMessage(CollectorBlockEntity entity) {
        return TextComponents.blockState((BlockState)entity.getBlockState()).get();
    }

    protected void addWidgets(CollectorBlockEntity entity) {
        this.addWidget((Widget)new ArrowButton(30, 37, false, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketIncreaseXRange(((CollectorBlockEntity)((Object)((Object)this.object))).getBlockPos()))));
        this.addWidget((Widget)new ArrowButton(30, 63, true, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketDecreaseXRange(((CollectorBlockEntity)((Object)((Object)this.object))).getBlockPos()))));
        this.addWidget((Widget)new ArrowButton(73, 37, false, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketIncreaseYRange(((CollectorBlockEntity)((Object)((Object)this.object))).getBlockPos()))));
        this.addWidget((Widget)new ArrowButton(73, 63, true, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketDecreaseYRange(((CollectorBlockEntity)((Object)((Object)this.object))).getBlockPos()))));
        this.addWidget((Widget)new ArrowButton(116, 37, false, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketIncreaseZRange(((CollectorBlockEntity)((Object)((Object)this.object))).getBlockPos()))));
        this.addWidget((Widget)new ArrowButton(116, 63, true, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketDecreaseZRange(((CollectorBlockEntity)((Object)((Object)this.object))).getBlockPos()))));
        this.whitelistButton = (WhitelistButton)this.addWidget((Widget)new WhitelistButton(175, 88, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketToggleWhitelist(((CollectorBlockEntity)((Object)((Object)this.object))).getBlockPos()))));
        this.whitelistButton.update(entity.filterWhitelist);
        this.durabilityButton = (DurabilityButton)this.addWidget((Widget)new DurabilityButton(197, 88, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketToggleDurability(((CollectorBlockEntity)((Object)((Object)this.object))).getBlockPos()))));
        this.durabilityButton.update(entity.filterDurability);
        this.showAreaButton = (ShowAreaButton)this.addWidget((Widget)new ShowAreaButton(160, 45, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketToggleShowArea(((CollectorBlockEntity)((Object)((Object)this.object))).getBlockPos()))));
        this.showAreaButton.update(entity.showArea);
        super.addWidgets((Object)entity);
    }

    protected void update(CollectorBlockEntity entity) {
        this.whitelistButton.update(entity.filterWhitelist);
        this.durabilityButton.update(entity.filterDurability);
        this.showAreaButton.update(entity.showArea);
        super.update((Object)entity);
    }

    protected void renderBackground(WidgetRenderContext context, int mouseX, int mouseY, CollectorBlockEntity entity) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)0.0f, (float)0.0f, (float)this.width(), (float)this.height());
        super.renderBackground(context, mouseX, mouseY, (Object)entity);
    }

    protected void renderForeground(WidgetRenderContext context, int mouseX, int mouseY, CollectorBlockEntity entity) {
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)entity.getBlockState().getBlock().getName(), (float)((float)this.width() / 2.0f), (float)6.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)ClientUtils.getPlayer().getInventory().getName(), (float)32.0f, (float)112.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"gui.itemcollectors.basic_collector.range", (Object[])new Object[]{entity.rangeX * 2 + 1, entity.rangeY * 2 + 1, entity.rangeZ * 2 + 1}).get(), (float)8.0f, (float)26.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.string((String)"x:").get(), (float)25.0f, (float)51.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.number((int)entity.rangeX).get(), (float)39.0f, (float)52.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.string((String)"y:").get(), (float)68.0f, (float)51.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.number((int)entity.rangeY).get(), (float)82.0f, (float)52.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.string((String)"z:").get(), (float)111.0f, (float)51.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.number((int)entity.rangeZ).get(), (float)125.0f, (float)52.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"gui.itemcollectors.advanced_collector.filter").get(), (float)8.0f, (float)78.0f);
        super.renderForeground(context, mouseX, mouseY, (Object)entity);
    }
}

