/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.squeezer;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.modcompat.jei.RecipeRegistryJeiRecipeWrapper;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class SqueezerRecipeJEI
extends RecipeRegistryJeiRecipeWrapper<CraftingInput, RecipeSqueezer, SqueezerRecipeJEI> {
    private final List<ItemStack> inputItem;
    private final NonNullList<RecipeSqueezer.IngredientChance> outputItems;
    private final Optional<FluidStack> outputFluid;

    public SqueezerRecipeJEI(RecipeSqueezer recipe) {
        super((RecipeType)RegistryEntries.RECIPETYPE_SQUEEZER.get(), (Recipe)recipe);
        this.inputItem = Arrays.stream(recipe.getInputIngredient().getItems()).collect(Collectors.toList());
        this.outputItems = recipe.getOutputItems();
        this.outputFluid = recipe.getOutputFluid();
    }

    protected SqueezerRecipeJEI() {
        super((RecipeType)RegistryEntries.RECIPETYPE_SQUEEZER.get(), null);
        this.inputItem = null;
        this.outputItems = null;
        this.outputFluid = Optional.empty();
    }

    public List<ItemStack> getInputItem() {
        return this.inputItem;
    }

    public NonNullList<RecipeSqueezer.IngredientChance> getOutputItems() {
        return this.outputItems;
    }

    public Optional<FluidStack> getOutputFluid() {
        return this.outputFluid;
    }

    protected RecipeType<RecipeSqueezer> getRecipeType() {
        return (RecipeType)RegistryEntries.RECIPETYPE_SQUEEZER.get();
    }

    protected SqueezerRecipeJEI newInstance(RecipeHolder<RecipeSqueezer> recipe) {
        return new SqueezerRecipeJEI((RecipeSqueezer)recipe.value());
    }

    public static List<SqueezerRecipeJEI> getAllRecipes() {
        return Lists.newArrayList(new SqueezerRecipeJEI().createAllRecipes().iterator());
    }
}

