/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.eatinganimation.pack;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.matyrobbrt.eatinganimation.EatingAnimation;
import com.matyrobbrt.eatinganimation.datagen.ItemModelGenerator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ModCompatResourcePack
extends AbstractPackResources {
    public static final Gson GSON = new Gson();
    public static final int NUMBER_OF_MODELS = 3;
    private final String namespace;
    private final Set<String> namespaces;
    private final Map<ResourceLocation, IoSupplier<InputStream>> resources = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
    private final byte[] packMcMeta;

    public ModCompatResourcePack(PackLocationInfo locationInfo, Path path, String namespace) {
        super(locationInfo);
        this.namespace = namespace;
        this.namespaces = Set.of("eatinganimation", namespace);
        Set<String> itemNames = ModCompatResourcePack.collectNames(path, namespace);
        for (String name : itemNames) {
            Path propsFile = path.resolve(name).resolve("properties.json");
            Properties props = Optional.ofNullable(Files.exists(propsFile, new LinkOption[0]) ? ModCompatResourcePack.readProps(propsFile) : null).orElse(new Properties(Optional.empty()));
            String itemModel = ItemModelGenerator.generateItemModel(name, namespace, props.resolveModel(namespace + ":item/" + name), props.values);
            this.resources.put(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("models/item/" + name + ".json")), (IoSupplier<InputStream>)((IoSupplier)() -> ModCompatResourcePack.toIs(itemModel)));
            for (int i = 0; i < 3; ++i) {
                Path fullPath = path.resolve(name).resolve(i + ".png");
                this.resources.put(ResourceLocation.fromNamespaceAndPath((String)"eatinganimation", (String)("textures/item/" + namespace + "/" + name + "_" + i + ".png")), (IoSupplier<InputStream>)((IoSupplier)() -> Files.newInputStream(fullPath, new OpenOption[0])));
                String animation = ItemModelGenerator.generateAnimationModel(name, namespace, i);
                this.resources.put(ResourceLocation.fromNamespaceAndPath((String)"eatinganimation", (String)("models/item/" + namespace + "/" + name + "_" + i + ".json")), (IoSupplier<InputStream>)((IoSupplier)() -> ModCompatResourcePack.toIs(animation)));
            }
        }
        this.packMcMeta = "{\"pack\":{\"description\":\"EatingAnimations %s compatibility\",\"pack_format\":%s}}".formatted(namespace, SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES)).getBytes(StandardCharsets.UTF_8);
    }

    private static ByteArrayInputStream toIs(String str) {
        return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
    }

    @Nullable
    private static Properties readProps(Path path) {
        Properties properties;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                properties = (Properties)((Pair)Properties.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    EatingAnimation.LOGGER.error("Exception trying to read model properties file:", (Throwable)e);
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return properties;
    }

    private static Set<String> collectNames(Path path, final String namespace) {
        final HashSet<String> names = new HashSet<String>();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    String name = dir.getFileName().toString();
                    if (!name.equals(namespace)) {
                        names.add(name);
                    }
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return names;
    }

    public void listResources(PackType type, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        if (type != PackType.CLIENT_RESOURCES || !namespace.equals("eatinganimation") && !namespace.equals(this.namespace)) {
            return;
        }
        this.resources.entrySet().stream().filter(it -> ((ResourceLocation)it.getKey()).getNamespace().equals(namespace) && ((ResourceLocation)it.getKey()).getPath().startsWith(path)).forEach(it -> resourceOutput.accept((Object)((ResourceLocation)it.getKey()), (Object)((IoSupplier)it.getValue())));
    }

    public Set<String> getNamespaces(PackType type) {
        return type == PackType.CLIENT_RESOURCES ? this.namespaces : Set.of();
    }

    public void close() {
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... paths) {
        if (paths.length == 1 && paths[0].equals("pack.mcmeta")) {
            return () -> new ByteArrayInputStream(this.packMcMeta);
        }
        return this.resources.get(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)String.join((CharSequence)"/", paths)));
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation location) {
        if (type != PackType.CLIENT_RESOURCES) {
            return null;
        }
        return this.resources.get(location);
    }

    public record Properties(Optional<String> defaultModel, List<Float> values) {
        public static final Codec<Properties> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.STRING.optionalFieldOf("layer0").forGetter(Properties::defaultModel), (App)Codec.FLOAT.listOf().optionalFieldOf("values", List.of(Float.valueOf(0.35f), Float.valueOf(0.7f), Float.valueOf(0.9f))).forGetter(Properties::values)).apply((Applicative)in, Properties::new));

        public Properties(Optional<String> defaultModel) {
            this(defaultModel, List.of(Float.valueOf(0.35f), Float.valueOf(0.7f), Float.valueOf(0.9f)));
        }

        public String resolveModel(String fallback) {
            return this.defaultModel.orElse(fallback);
        }
    }
}

