/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.network.packet;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.gui.microchip.MicrochipMenu;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.MicrochipObject;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponents;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.note.StickyNoteEntry;
import net.swedz.little_big_redstone.microchip.wire.Wire;
import net.swedz.little_big_redstone.network.LBRCustomPacket;
import net.swedz.tesseract.neoforge.api.Bounds;
import net.swedz.tesseract.neoforge.helper.TransferHelper;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record PlaceTakeMicrochipObjectPacket(int containerId, int x, int y, boolean place, boolean leftClick, boolean shift) implements LBRCustomPacket
{
    public static final StreamCodec<ByteBuf, PlaceTakeMicrochipObjectPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, PlaceTakeMicrochipObjectPacket::containerId, (StreamCodec)ByteBufCodecs.VAR_INT, PlaceTakeMicrochipObjectPacket::x, (StreamCodec)ByteBufCodecs.VAR_INT, PlaceTakeMicrochipObjectPacket::y, (StreamCodec)ByteBufCodecs.BOOL, PlaceTakeMicrochipObjectPacket::place, (StreamCodec)ByteBufCodecs.BOOL, PlaceTakeMicrochipObjectPacket::leftClick, (StreamCodec)ByteBufCodecs.BOOL, PlaceTakeMicrochipObjectPacket::shift, PlaceTakeMicrochipObjectPacket::new);

    /*
     * Enabled aggressive block sorting
     */
    public void handle(PacketContext context) {
        AbstractContainerMenu abstractContainerMenu;
        context.assertServerbound();
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        String playerName = player.getGameProfile().getName();
        if (player.hasContainerOpen() && (abstractContainerMenu = player.containerMenu) instanceof MicrochipMenu) {
            MicrochipMenu menu = (MicrochipMenu)abstractContainerMenu;
            if (menu.containerId == this.containerId) {
                Microchip microchip = menu.microchip();
                LogicComponents components = microchip.components();
                ItemStack heldItem = menu.getCarried();
                if (this.place) {
                    if (heldItem.getItem() instanceof StickyNoteItem) {
                        if (!microchip.size().bounds().normalize().contains(new Bounds(this.x, this.y, 16, 16))) {
                            LBR.LOGGER.warn("Received PlaceTakeMicrochipObjectPacket from {} with an invalid placement position, discarding", (Object)playerName);
                            return;
                        }
                        StickyNoteEntry stickyNote = microchip.stickyNotes().add(this.x, this.y, heldItem);
                        if (stickyNote == null) {
                            LBR.LOGGER.warn("Received PlaceTakeMicrochipObjectPacket from {} and failed to add the sticky note, discarding", (Object)playerName);
                            return;
                        }
                        microchip.markDirty();
                        if (player.hasInfiniteMaterials()) {
                            if (!this.leftClick) return;
                        }
                        heldItem.shrink(1);
                        return;
                    }
                    if (!heldItem.has(LBRComponents.LOGIC)) {
                        LBR.LOGGER.warn("Received PlaceTakeMicrochipObjectPacket from {} while not carrying a valid item in their cursor ({}), discarding", (Object)playerName, (Object)heldItem.getItem());
                        return;
                    }
                    LogicComponent component = (LogicComponent)heldItem.get(LBRComponents.LOGIC);
                    if (!microchip.size().bounds().normalize().contains(component.size().toBounds(this.x, this.y))) {
                        LBR.LOGGER.warn("Received PlaceTakeMicrochipObjectPacket from {} with an invalid placement position, discarding", (Object)playerName);
                        return;
                    }
                    LogicEntry logic = components.add(this.x, this.y, component);
                    if (logic == null) {
                        LBR.LOGGER.warn("Received PlaceTakeMicrochipObjectPacket from {} and failed to add the logic component, discarding", (Object)playerName);
                        return;
                    }
                    microchip.components().updateValidity();
                    menu.placeCarriedWires(logic.slot());
                    microchip.markDirty();
                    if (player.hasInfiniteMaterials()) {
                        if (!this.leftClick) return;
                    }
                    heldItem.shrink(1);
                    return;
                }
                if (!heldItem.isEmpty()) {
                    LBR.LOGGER.warn("Received PlaceTakeMicrochipObjectPacket from {} while already carrying an item in their cursor, discarding", (Object)playerName);
                    return;
                }
                MicrochipObject object = microchip.findAt(this.x, this.y);
                if (object instanceof StickyNoteEntry) {
                    StickyNoteEntry note = (StickyNoteEntry)object;
                    microchip.stickyNotes().remove(note);
                    ItemStack stack = note.toStack();
                    if (!this.shift || TransferHelper.insert((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), (ItemStack)stack) <= 0) {
                        menu.setCarried(stack);
                    }
                    microchip.markDirty();
                    return;
                }
                if (!(object instanceof LogicEntry)) {
                    LBR.LOGGER.warn("Received PlaceTakeMicrochipObjectPacket from {} with an invalid take position ({}, {}), discarding", new Object[]{playerName, this.x, this.y});
                    return;
                }
                LogicEntry logic = (LogicEntry)object;
                List<Wire> wiresPopped = components.remove(logic);
                ItemStack stack = logic.toStack();
                if (!this.shift || TransferHelper.insert((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), (ItemStack)stack) <= 0) {
                    menu.setCarried(stack);
                    menu.setCarriedWires(logic.slot(), wiresPopped);
                } else if (!player.hasInfiniteMaterials() && !wiresPopped.isEmpty()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack(LBRItems.REDSTONE_BIT, wiresPopped.size()));
                }
                microchip.markDirty();
                return;
            }
        }
        LBR.LOGGER.warn("Received PlaceTakeMicrochipObjectPacket from {} while not in a microchip menu (or in expired one?), discarding", (Object)playerName);
    }
}

