/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.config;

import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponents;
import net.swedz.little_big_redstone.microchip.object.logic.LogicPortHolder;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfigMenuBuilder;

public abstract class LogicConfig<C extends LogicConfig<C>>
implements LogicPortHolder {
    protected boolean valid = true;
    protected Boolean[] outputLocks;
    protected boolean hidden = false;

    public final boolean isValid() {
        return this.valid;
    }

    public final void recalculateValidity(LogicComponents components) {
        this.valid = this.calculateValidity(components);
    }

    protected boolean calculateValidity(LogicComponents components) {
        return true;
    }

    public final void setOutputLock(int index, Boolean lock) {
        if (this.outputLocks == null || this.outputLocks.length <= index) {
            this.outputLocks = this.outputLocks == null ? new Boolean[index + 1] : Arrays.copyOf(this.outputLocks, index + 1);
        }
        this.outputLocks[index] = lock;
    }

    public final Boolean getOutputLock(int index) {
        return this.outputLocks == null || this.outputLocks.length <= index ? null : this.outputLocks[index];
    }

    public final void hide() {
        this.hidden = true;
    }

    public final boolean isVisible() {
        return !this.hidden;
    }

    public void appendHoverText(List<Component> lines) {
    }

    public boolean hasMenu() {
        return false;
    }

    public void buildMenu(LogicConfigMenuBuilder builder, int width, int height) {
    }

    protected abstract void internalLoadFrom(C var1);

    public final void loadFrom(C other) {
        this.valid = ((LogicConfig)other).valid;
        this.outputLocks = ((LogicConfig)other).outputLocks;
        this.hidden = ((LogicConfig)other).hidden;
        this.internalLoadFrom(other);
    }

    public abstract void resetForPickup();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

