/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.item.stickynote;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteEntity;
import net.swedz.little_big_redstone.gui.stickynote.reference.HeldItemStickyNoteReference;
import net.swedz.little_big_redstone.item.DyeColoredItem;
import net.swedz.little_big_redstone.item.stickynote.StickyNote;
import net.swedz.little_big_redstone.proxy.LBRProxy;
import net.swedz.tesseract.neoforge.helper.DirectionHelper;
import net.swedz.tesseract.neoforge.proxy.Proxies;

public final class StickyNoteItem
extends Item
implements DyeColoredItem {
    private final DyeColor color;

    public static DyeColor getDefaultTextColor(DyeColor color) {
        return switch (color) {
            case DyeColor.GRAY, DyeColor.BLACK -> DyeColor.WHITE;
            default -> DyeColor.BLACK;
        };
    }

    public StickyNoteItem(Item.Properties properties, DyeColor color) {
        super(properties.component(LBRComponents.STICKY_NOTE, (Object)StickyNote.EMPTY).component(LBRComponents.STICKY_NOTE_TEXT_COLOR, (Object)StickyNoteItem.getDefaultTextColor(color)));
        this.color = color;
    }

    @Override
    public DyeColor color() {
        return this.color;
    }

    private boolean mayPlace(Player player, Direction direction, ItemStack itemStack, BlockPos pos) {
        return !player.level().isOutsideBuildHeight(pos) && player.mayUseItemAt(pos, direction, itemStack);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            ((LBRProxy)Proxies.get(LBRProxy.class)).openStickyNote(new HeldItemStickyNoteReference(hand, stack), player.isCrouching());
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    private static StickyNoteEntity.Quadrant findClosestQuadrant(BlockPos blockPos, Direction side, Direction facing, Vec3 pos) {
        Vec3 faceCenter = blockPos.getCenter().subtract((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()).relative(side, 0.5);
        pos = pos.subtract((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        Direction up = DirectionHelper.relativeUp((Direction)side, (Direction)facing);
        Direction down = DirectionHelper.relativeDown((Direction)side, (Direction)facing);
        Direction left = DirectionHelper.relativeLeft((Direction)side, (Direction)facing);
        Direction right = DirectionHelper.relativeRight((Direction)side, (Direction)facing);
        StickyNoteEntity.Quadrant closestQuadrant = null;
        double closestQuadrantDistance = Double.MAX_VALUE;
        for (StickyNoteEntity.Quadrant quadrant : StickyNoteEntity.Quadrant.values()) {
            Vec3 corner = quadrant.relative(up, down, left, right, faceCenter, 0.5);
            double distance = pos.distanceTo(corner);
            if (!(distance < closestQuadrantDistance)) continue;
            closestQuadrant = quadrant;
            closestQuadrantDistance = distance;
        }
        return closestQuadrant;
    }

    public InteractionResult useOn(UseOnContext context) {
        Component itemName;
        StickyNote note;
        Direction direction = context.getClickedFace();
        BlockPos placePos = context.getClickedPos().relative(direction);
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        if (player != null && !this.mayPlace(player, direction, stack, placePos)) {
            return InteractionResult.FAIL;
        }
        Direction facing = direction.getAxis().isVertical() ? Direction.fromYRot((double)player.getYRot()).getOpposite() : Direction.SOUTH;
        StickyNoteEntity.Quadrant quadrant = StickyNoteItem.findClosestQuadrant(context.getClickedPos(), direction, facing, context.getClickLocation());
        DyeColor textColor = (DyeColor)stack.get(LBRComponents.STICKY_NOTE_TEXT_COLOR);
        Level level = context.getLevel();
        StickyNoteEntity entity = new StickyNoteEntity(level, placePos, direction, facing, quadrant, this.color, textColor);
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty()) {
            EntityType.updateCustomEntityTag((Level)level, (Player)player, (Entity)entity, (CustomData)customData);
        }
        if (!(note = (StickyNote)stack.getOrDefault(LBRComponents.STICKY_NOTE, (Object)StickyNote.EMPTY)).isEmpty()) {
            entity.setNote(note);
        }
        if ((itemName = (Component)stack.get(DataComponents.CUSTOM_NAME)) != null) {
            entity.setItemName(itemName);
        }
        if (entity.survives()) {
            if (!level.isClientSide()) {
                entity.playPlacementSound();
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
                level.addFreshEntity((Entity)entity);
            }
            stack.consume(1, (LivingEntity)player);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.CONSUME;
    }
}

