/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.item.logicarray;

import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.gui.logicarray.LogicArrayMenu;
import net.swedz.little_big_redstone.item.DyeColoredItem;
import net.swedz.little_big_redstone.item.logicarray.tooltip.LogicArrayTooltipData;
import net.swedz.tesseract.neoforge.helper.TransferHelper;

public final class LogicArrayItem
extends Item
implements DyeColoredItem {
    public static final int ROWS = 4;
    public static final int COLUMNS = 7;
    public static final int MAX_SLOTS = 28;
    private final DyeColor color;

    public LogicArrayItem(Item.Properties properties, DyeColor color) {
        super(properties.stacksTo(1).component(LBRComponents.LOGIC_ARRAY_STORAGE, (Object)ItemContainerContents.EMPTY));
        this.color = color;
    }

    @Override
    public DyeColor color() {
        return this.color;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        final ItemStack stack = player.getItemInHand(hand);
        ItemContainerContents storage = (ItemContainerContents)stack.get(LBRComponents.LOGIC_ARRAY_STORAGE);
        final int logicArraySlot = player.getInventory().selected;
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return LogicArrayItem.this.getDescription();
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
                return new LogicArrayMenu(containerId, playerInventory, (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM), logicArraySlot);
            }
        }, buf -> buf.writeVarInt(logicArraySlot));
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    private boolean overrideStackedOn(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        IItemHandler capability = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (capability != null) {
            if (other.isEmpty()) {
                ItemStack extracted = TransferHelper.extractFirst((IItemHandler)capability, (int)64);
                if (!extracted.isEmpty()) {
                    if (access == null) {
                        slot.safeInsert(extracted);
                    } else {
                        access.set(extracted);
                    }
                }
            } else {
                int inserted = TransferHelper.insert((IItemHandler)capability, (ItemStack)other);
                if (inserted > 0) {
                    other.shrink(inserted);
                }
            }
            return true;
        }
        return false;
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (stack.getCount() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.allowModification(player) && slot.mayPlace(stack)) {
            ItemStack other = slot.getItem();
            return this.overrideStackedOn(stack, other, slot, action, player, null);
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (stack.getCount() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.allowModification(player) && slot.mayPlace(other)) {
            return this.overrideStackedOn(stack, other, slot, action, player, access);
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return !stack.has(DataComponents.HIDE_TOOLTIP) && !stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((ItemContainerContents)stack.get(LBRComponents.LOGIC_ARRAY_STORAGE)).map(LogicArrayTooltipData::new) : Optional.empty();
    }
}

