/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.item;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriPredicate;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.LBRTags;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlockEntity;
import net.swedz.little_big_redstone.item.DyeColoredItem;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.MicrochipObject;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.note.StickyNoteEntry;
import net.swedz.little_big_redstone.network.packet.FloppyDiskGuiOverlayUpdatePacket;
import net.swedz.little_big_redstone.proxy.LBRProxy;
import net.swedz.tesseract.neoforge.api.tuple.Pair;
import net.swedz.tesseract.neoforge.event.PlayerInventoryChangeEvent;
import net.swedz.tesseract.neoforge.helper.TransferHelper;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import org.apache.commons.lang3.function.TriFunction;

@EventBusSubscriber(modid="little_big_redstone")
public final class FloppyDiskItem
extends Item
implements DyeColoredItem {
    private final DyeColor color;

    public FloppyDiskItem(Item.Properties properties, DyeColor color) {
        super(properties.stacksTo(1).component(LBRComponents.FLOPPY_DISK, null));
        this.color = color;
    }

    @Override
    public DyeColor color() {
        return this.color;
    }

    public static ItemStack getHeldStack(Player player) {
        ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.getItemInHand(InteractionHand.OFF_HAND);
        return mainHand.is(LBRTags.Items.FLOPPY_DISKS) ? mainHand : (offHand.is(LBRTags.Items.FLOPPY_DISKS) ? offHand : ItemStack.EMPTY);
    }

    private static Map<Pair<StickyNoteItem, DyeColor>, Integer> getStickyNotesNeeded(Microchip.Immutable microchip) {
        HashMap needed = Maps.newHashMap();
        for (StickyNoteEntry stickyNote : microchip.stickyNotes()) {
            StickyNoteItem item = (StickyNoteItem)LBRItems.stickyNote(stickyNote.noteColor()).get();
            Pair key = new Pair((Object)item, (Object)stickyNote.textColor());
            needed.compute(key, (__, value) -> value == null ? 1 : value + 1);
        }
        return needed;
    }

    private static Map<Pair<LogicType<?>, Optional<DyeColor>>, Integer> getComponentsNeeded(Microchip.Immutable microchip) {
        HashMap needed = Maps.newHashMap();
        for (LogicEntry entry : microchip.components()) {
            LogicComponent component = entry.component();
            Pair key = new Pair(component.type(), component.color());
            needed.compute(key, (__, value) -> value == null ? 1 : value + 1);
        }
        return needed;
    }

    private static <K, V, E extends MicrochipObject> List<Integer> identifyReusableItems(Player player, Microchip.Immutable microchip, Microchip.Immutable targetMicrochip, boolean simulate, Iterable<E> targetEntries, Map<Pair<K, V>, Integer> needed, TriPredicate<E, K, V> entryPredicate, TriPredicate<ItemStack, K, V> stackPredicate, TriFunction<K, V, Integer, ItemStack> stackCreator, List<ItemStack> presentItems, List<ItemStack> missingItems) {
        ArrayList reused = Lists.newArrayList();
        for (Map.Entry<Pair<K, V>, Integer> entry : needed.entrySet()) {
            Object key = entry.getKey().a();
            Object value = entry.getKey().b();
            int totalNeeded = entry.getValue();
            int available = 0;
            for (MicrochipObject reuseEntry : targetEntries) {
                if (!entryPredicate.test((Object)reuseEntry, key, value)) continue;
                reused.add(reuseEntry.slot());
                if (++available != totalNeeded) continue;
                break;
            }
            if (available < totalNeeded) {
                available += TransferHelper.extractAny((Inventory)player.getInventory(), stack -> stackPredicate.test(stack, key, value), (int)(totalNeeded - available), (boolean)true, (boolean)simulate);
            }
            if (available != totalNeeded) {
                missingItems.add((ItemStack)stackCreator.apply(key, value, (Object)(totalNeeded - available)));
            }
            if (available <= 0) continue;
            presentItems.add((ItemStack)stackCreator.apply(key, value, (Object)available));
        }
        return reused;
    }

    public static ConsumeResult consumeItems(Player player, Microchip.Immutable microchip, Microchip.Immutable targetMicrochip, boolean simulate) {
        int wiresReused;
        if (player.hasInfiniteMaterials()) {
            return new ConsumeResult();
        }
        ArrayList presentItems = Lists.newArrayList();
        ArrayList missingItems = Lists.newArrayList();
        int totalWiresNeeded = microchip.wireCount();
        int wiresAvailable = wiresReused = Math.min(totalWiresNeeded, targetMicrochip.wireCount());
        if ((wiresAvailable += TransferHelper.extractAny((Inventory)player.getInventory(), item -> item.is(LBRItems.REDSTONE_BIT.get()), (int)(totalWiresNeeded - wiresAvailable), (boolean)true, (boolean)simulate)) != microchip.wireCount()) {
            missingItems.add(new ItemStack((ItemLike)LBRItems.REDSTONE_BIT.get(), totalWiresNeeded - wiresAvailable));
        }
        if (wiresAvailable > 0) {
            presentItems.add(new ItemStack((ItemLike)LBRItems.REDSTONE_BIT.get(), wiresAvailable));
        }
        List<Integer> logicReused = FloppyDiskItem.identifyReusableItems(player, microchip, targetMicrochip, simulate, targetMicrochip.components(), FloppyDiskItem.getComponentsNeeded(microchip), (entry, type, dye) -> entry.component().type().equals(type) && entry.component().color().equals(dye), (stack, type, dye) -> {
            if (stack.has(LBRComponents.LOGIC)) {
                LogicComponent component = (LogicComponent)stack.get(LBRComponents.LOGIC);
                return component.type().equals(type) && component.color().equals(dye);
            }
            return false;
        }, (type, dye, count) -> {
            LogicComponent component = type.defaultFactory().create();
            component.setColor((Optional<DyeColor>)dye);
            ItemStack stack = type.toStack(component);
            stack.setCount(count.intValue());
            return stack;
        }, presentItems, missingItems);
        List<Integer> notesReused = FloppyDiskItem.identifyReusableItems(player, microchip, targetMicrochip, simulate, targetMicrochip.stickyNotes(), FloppyDiskItem.getStickyNotesNeeded(microchip), (entry, item, textColor) -> entry.noteColor().equals((Object)item.color()) && entry.textColor().equals(textColor), (stack, item, textColor) -> stack.is((Item)item) && textColor.equals(stack.get(LBRComponents.STICKY_NOTE_TEXT_COLOR)), (item, textColor, count) -> {
            ItemStack stack = new ItemStack((ItemLike)item, count.intValue());
            stack.set(LBRComponents.STICKY_NOTE_TEXT_COLOR, textColor);
            return stack;
        }, presentItems, missingItems);
        return new ConsumeResult(presentItems, missingItems, wiresReused, logicReused, notesReused);
    }

    private static void dropAll(Player player, Microchip microchip, ConsumeResult result) {
        if (player.hasInfiniteMaterials()) {
            return;
        }
        for (MicrochipObject entry : microchip.components()) {
            if (result.logicReused().contains(((LogicEntry)entry).slot())) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((LogicEntry)entry).toStack());
        }
        for (MicrochipObject entry : microchip.stickyNotes()) {
            if (result.notesReused().contains(((StickyNoteEntry)entry).slot())) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((StickyNoteEntry)entry).toStack());
        }
        int wiresToDrop = microchip.wires().values().size() - result.wiresReused();
        if (wiresToDrop > 0) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack(LBRItems.REDSTONE_BIT, wiresToDrop));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    private static void onPlaceMicrochipWithFloppyDisk(BlockEvent.EntityPlaceEvent event) {
        BlockEntity blockEntity;
        Microchip.Immutable microchip;
        ServerPlayer player;
        ItemStack offhand;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (offhand = (player = (ServerPlayer)entity).getItemInHand(InteractionHand.OFF_HAND)).has(LBRComponents.FLOPPY_DISK) && (microchip = (Microchip.Immutable)offhand.get(LBRComponents.FLOPPY_DISK)) != null && (blockEntity = event.getLevel().getBlockEntity(event.getPos())) instanceof MicrochipBlockEntity) {
            MicrochipBlockEntity microchipBlockEntity = (MicrochipBlockEntity)blockEntity;
            Microchip.Immutable targetMicrochip = microchipBlockEntity.microchip().immutable();
            ConsumeResult result = FloppyDiskItem.consumeItems((Player)player, microchip, targetMicrochip, true);
            if (result.isSuccess()) {
                FloppyDiskItem.consumeItems((Player)player, microchip, targetMicrochip, false);
                FloppyDiskItem.dropAll((Player)player, microchipBlockEntity.microchip(), result);
                microchipBlockEntity.microchip().loadFrom(microchip);
                player.displayClientMessage((Component)LBRText.FLOPPY_DISK_APPLY_SUCCESS.text(), true);
            } else {
                player.displayClientMessage((Component)LBRText.FLOPPY_DISK_APPLY_FAILURE.text(), true);
            }
            new FloppyDiskGuiOverlayUpdatePacket(true).sendToClient(player);
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            InteractionHand usedHand = context.getHand();
            ItemStack itemStack = player.getItemInHand(usedHand);
            BlockEntity hitBlockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
            if (hitBlockEntity instanceof MicrochipBlockEntity) {
                MicrochipBlockEntity microchipBlockEntity = (MicrochipBlockEntity)hitBlockEntity;
                if (!context.getLevel().isClientSide()) {
                    Microchip.Immutable microchip;
                    if (player.isShiftKeyDown()) {
                        itemStack.set(LBRComponents.FLOPPY_DISK, (Object)microchipBlockEntity.microchip().immutable());
                        player.displayClientMessage((Component)LBRText.FLOPPY_DISK_SAVE.text(), true);
                    } else if (itemStack.has(LBRComponents.FLOPPY_DISK) && !player.getCooldowns().isOnCooldown((Item)this) && (microchip = (Microchip.Immutable)itemStack.get(LBRComponents.FLOPPY_DISK)) != null) {
                        Microchip.Immutable targetMicrochip = microchipBlockEntity.microchip().immutable();
                        ConsumeResult result = FloppyDiskItem.consumeItems(player, microchip, targetMicrochip, true);
                        if (result.isSuccess()) {
                            FloppyDiskItem.consumeItems(player, microchip, targetMicrochip, false);
                            FloppyDiskItem.dropAll(player, microchipBlockEntity.microchip(), result);
                            microchipBlockEntity.microchip().loadFrom(microchip);
                            player.displayClientMessage((Component)LBRText.FLOPPY_DISK_APPLY_SUCCESS.text(), true);
                        } else {
                            player.displayClientMessage((Component)LBRText.FLOPPY_DISK_APPLY_FAILURE.text(), true);
                        }
                        player.getCooldowns().addCooldown((Item)this, 20);
                        new FloppyDiskGuiOverlayUpdatePacket(true).sendToClient((ServerPlayer)player);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide());
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player.isShiftKeyDown()) {
            stack.remove(LBRComponents.FLOPPY_DISK);
            player.displayClientMessage((Component)LBRText.FLOPPY_DISK_CLEAR.text(), true);
        } else if (level.isClientSide()) {
            ((LBRProxy)Proxies.get(LBRProxy.class)).openFloppyDisk(usedHand);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !newStack.is(oldStack.getItem());
    }

    @SubscribeEvent
    private static void onPlayerInventoryChange(PlayerInventoryChangeEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            new FloppyDiskGuiOverlayUpdatePacket(false).sendToClient(player2);
        }
    }

    public record ConsumeResult(List<ItemStack> present, List<ItemStack> missing, int wiresReused, List<Integer> logicReused, List<Integer> notesReused) implements Iterable<ItemStack>
    {
        public ConsumeResult(List<ItemStack> present, List<ItemStack> missing, int wiresReused, List<Integer> logicReused, List<Integer> notesReused) {
            present = Lists.newArrayList(present);
            missing = Lists.newArrayList(missing);
            present.sort(Comparator.comparingInt(ItemStack::getCount).reversed());
            missing.sort(Comparator.comparingInt(ItemStack::getCount).reversed());
            this.present = Collections.unmodifiableList(present);
            this.missing = Collections.unmodifiableList(missing);
            this.wiresReused = wiresReused;
            this.logicReused = Collections.unmodifiableList(logicReused);
            this.notesReused = Collections.unmodifiableList(notesReused);
        }

        public ConsumeResult() {
            this(List.of(), List.of(), 0, List.of(), List.of());
        }

        public boolean isSuccess() {
            return this.missing.isEmpty();
        }

        public int size() {
            return this.present.size() + this.missing.size();
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return Iterators.concat(this.present.iterator(), this.missing.iterator());
        }
    }
}

